/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.gf.impl.model;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSObject;
import org.verapdf.metadata.fixer.entity.InfoDictionary;
import org.verapdf.metadata.fixer.gf.utils.DateConverter;

public class InfoDictionaryImpl
implements InfoDictionary {
    private final COSObject info;
    private final COSDocument doc;

    public InfoDictionaryImpl(COSObject info, COSDocument doc) {
        if (info == null || info.empty() || doc == null) {
            throw new IllegalArgumentException("Info dictionary representation can not be null");
        }
        this.info = info;
        this.doc = doc;
    }

    public String getTitle() {
        return this.info.getStringKey(ASAtom.TITLE);
    }

    public void setTitle(String title) {
        this.info.setStringKey(ASAtom.TITLE, title);
    }

    public String getSubject() {
        return this.info.getStringKey(ASAtom.SUBJECT);
    }

    public void setSubject(String subject) {
        this.info.setStringKey(ASAtom.SUBJECT, subject);
    }

    public String getAuthor() {
        return this.info.getStringKey(ASAtom.AUTHOR);
    }

    public void setAuthor(String author) {
        this.info.setStringKey(ASAtom.AUTHOR, author);
    }

    public String getProducer() {
        return this.info.getStringKey(ASAtom.PRODUCER);
    }

    public void setProducer(String producer) {
        this.info.setStringKey(ASAtom.PRODUCER, producer);
    }

    public String getKeywords() {
        return this.info.getStringKey(ASAtom.KEYWORDS);
    }

    public void setKeywords(String keywords) {
        this.info.setStringKey(ASAtom.KEYWORDS, keywords);
    }

    public String getCreator() {
        return this.info.getStringKey(ASAtom.CREATOR);
    }

    public void setCreator(String creator) {
        this.info.setStringKey(ASAtom.CREATOR, creator);
    }

    public String getCreationDate() {
        return this.info.getStringKey(ASAtom.CREATION_DATE);
    }

    public void setCreationDate(String creationDate) {
        this.info.setStringKey(ASAtom.CREATION_DATE, DateConverter.toPDFFormat(creationDate));
    }

    public String getModificationDate() {
        return this.info.getStringKey(ASAtom.MOD_DATE);
    }

    public void setModificationDate(String modificationDate) {
        this.info.setStringKey(ASAtom.MOD_DATE, DateConverter.toPDFFormat(modificationDate));
    }

    public boolean isNeedToBeUpdated() {
        return this.doc.isObjectChanged(this.info);
    }

    public void setNeedToBeUpdated(boolean needToBeUpdated) {
        if (needToBeUpdated) {
            this.doc.addChangedObject(this.info);
        } else {
            this.doc.removeChangedObject(this.info);
        }
    }
}

