/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.CharTable;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.filters.COSFilterASCII85Decode;
import org.verapdf.cos.filters.COSFilterASCIIHexDecode;
import org.verapdf.io.InternalInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.parser.Token;

public class BaseParser {
    private static final Logger LOGGER = Logger.getLogger(BaseParser.class.getCanonicalName());
    private static final byte ASCII_ZERO = 48;
    private static final byte ASCII_NINE = 57;
    protected SeekableInputStream source;
    private Token token;

    public BaseParser(SeekableInputStream stream) throws IOException {
        if (stream == null) {
            throw new IOException("Can't create SeekableStream, passed seekableeStream is null");
        }
        this.source = stream;
    }

    public BaseParser(String fileName) throws IOException {
        if (fileName == null) {
            throw new FileNotFoundException("Can't create SeekableStream from file, filename is null");
        }
        this.source = new InternalInputStream(fileName);
    }

    public BaseParser(InputStream fileStream) throws IOException {
        if (fileStream == null) {
            throw new IOException("Can't create SeekableStream, fileStream is null");
        }
        if (fileStream instanceof SeekableInputStream) {
            this.source = (SeekableInputStream)fileStream;
        } else {
            try {
                this.source = SeekableInputStream.getSeekableStream(fileStream);
            }
            finally {
                fileStream.close();
            }
        }
    }

    public void closeInputStream() throws IOException {
        this.source.close();
    }

    protected Token getToken() {
        return this.token;
    }

    protected String getLine() throws IOException {
        this.initializeToken();
        this.token.clearValue();
        byte ch = this.source.readByte();
        while (!this.source.isEOF() && ch != 10 && ch != 13) {
            this.appendToToken(ch);
            ch = this.source.readByte();
        }
        return this.token.getValue();
    }

    protected byte[] getLineBytes() throws IOException {
        this.getLine();
        return this.token.getByteValue();
    }

    protected String getLine(int offset) throws IOException {
        this.initializeToken();
        this.token.clearValue();
        this.source.seek(offset);
        byte ch = this.source.readByte();
        while (!this.source.isEOF() && ch != 10 && ch != 13) {
            this.appendToToken(ch);
            ch = this.source.readByte();
        }
        return this.token.getValue();
    }

    protected String readUntilDelimiter() throws IOException {
        this.initializeToken();
        this.token.clearValue();
        byte ch = this.source.readByte();
        while (!CharTable.isSpace(ch) && !CharTable.isTokenDelimiter(ch)) {
            this.appendToToken(ch);
            if (this.source.isEOF()) break;
            ch = this.source.readByte();
        }
        if (CharTable.isSpace(ch) || CharTable.isTokenDelimiter(ch)) {
            this.source.unread();
        }
        return this.token.getValue();
    }

    protected boolean findKeyword(Token.Keyword keyword) throws IOException {
        this.nextToken();
        while (this.token.type != Token.Type.TT_EOF && (this.token.type != Token.Type.TT_KEYWORD || this.token.keyword != keyword)) {
            this.nextToken();
        }
        return this.token.type == Token.Type.TT_KEYWORD && this.token.keyword == keyword;
    }

    protected boolean findKeyword(Token.Keyword keyword, int lookUpSize) throws IOException {
        long endOffset = this.source.getOffset() + (long)lookUpSize < this.source.getStreamLength() ? this.source.getOffset() + (long)lookUpSize : this.source.getStreamLength();
        this.nextToken();
        while (this.token.type != Token.Type.TT_EOF && (this.token.type != Token.Type.TT_KEYWORD || this.token.keyword != keyword) && this.source.getOffset() < endOffset) {
            this.nextToken();
        }
        return this.token.type == Token.Type.TT_KEYWORD && this.token.keyword == keyword;
    }

    protected void nextToken() throws IOException {
        this.skipSpaces(true);
        if (this.source.isEOF()) {
            this.token.type = Token.Type.TT_EOF;
            return;
        }
        this.token.type = Token.Type.TT_NONE;
        byte ch = this.source.readByte();
        switch (ch) {
            case 40: {
                this.token.type = Token.Type.TT_LITSTRING;
                this.readLitString();
                break;
            }
            case 41: {
                break;
            }
            case 60: {
                ch = this.source.readByte();
                if (ch == 60) {
                    this.token.type = Token.Type.TT_OPENDICT;
                    break;
                }
                if (ch == 126) {
                    this.token.type = Token.Type.TT_HEXSTRING;
                    this.readASCII85();
                    break;
                }
                this.source.unread();
                this.token.type = Token.Type.TT_HEXSTRING;
                this.readHexString();
                break;
            }
            case 62: {
                ch = this.source.readByte();
                if (ch == 62) {
                    this.token.type = Token.Type.TT_CLOSEDICT;
                    break;
                }
                throw new IOException("Unknown symbol " + ch + " after '>'");
            }
            case 91: {
                this.token.type = Token.Type.TT_OPENARRAY;
                break;
            }
            case 93: {
                this.token.type = Token.Type.TT_CLOSEARRAY;
                break;
            }
            case 123: {
                break;
            }
            case 125: {
                break;
            }
            case 47: {
                this.token.type = Token.Type.TT_NAME;
                this.readName();
                break;
            }
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                this.source.unread();
                this.readNumber();
                break;
            }
            case 45: {
                this.readNumber();
                this.token.integer = -this.token.integer;
                this.token.real = -this.token.real;
                break;
            }
            default: {
                this.source.unread();
                this.readToken();
                this.token.toKeyword();
                if (this.token.keyword != Token.Keyword.KW_NONE) break;
                this.token.type = Token.Type.TT_NONE;
            }
        }
    }

    public ASInputStream getRandomAccess(long length) throws IOException {
        ASInputStream result = this.source.getStream(this.source.getOffset(), length);
        this.source.seekFromCurrentPosition(length);
        return result;
    }

    protected boolean isNextByteEOL() throws IOException {
        byte c = (byte)this.source.peek();
        return BaseParser.isLF(c) || BaseParser.isCR(c);
    }

    protected void skipSingleEol() throws IOException {
        byte c = this.source.readByte();
        if (BaseParser.isCR(c)) {
            c = this.source.readByte();
            if (!BaseParser.isLF(c)) {
                this.source.unread();
            }
        } else if (!BaseParser.isLF(c)) {
            this.source.unread();
        }
    }

    protected void skipSpaces() throws IOException {
        this.skipSpaces(false);
    }

    protected void skipSingleSpace() throws IOException {
        this.skipSingleSpace(false);
    }

    protected void skipSpaces(boolean skipComment) throws IOException {
        while (this.skipSingleSpace(skipComment)) {
        }
    }

    protected boolean skipSingleSpace(boolean skipComment) throws IOException {
        if (this.source.isEOF()) {
            return false;
        }
        byte ch = this.source.readByte();
        if (CharTable.isSpace(ch)) {
            return true;
        }
        if (ch == 37 && skipComment) {
            this.skipComment();
            return true;
        }
        this.source.unread();
        return false;
    }

    protected boolean isDigit() throws IOException {
        return BaseParser.isDigit((byte)this.source.peek());
    }

    protected static boolean isDigit(byte c) {
        return c >= 48 && c <= 57;
    }

    protected static boolean isHexDigit(byte ch) {
        return BaseParser.isDigit(ch) || ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }

    protected static boolean isLF(int c) {
        return 10 == c;
    }

    protected static boolean isCR(int c) {
        return 13 == c;
    }

    protected static boolean isFF(int c) {
        return 12 == c;
    }

    private void skipEOL() throws IOException {
        byte ch = this.source.readByte();
        if (BaseParser.isLF(ch)) {
            return;
        }
        if (BaseParser.isCR(ch) && BaseParser.isLF(ch = this.source.readByte())) {
            return;
        }
        this.source.unread();
    }

    private void skipComment() throws IOException {
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (!this.isEOL(ch)) continue;
            return;
        }
    }

    protected boolean isEOL(byte ch) throws IOException {
        if (BaseParser.isLF(ch)) {
            return true;
        }
        if (BaseParser.isCR(ch)) {
            ch = this.source.readByte();
            if (!BaseParser.isLF(ch)) {
                this.source.unread();
            }
            return true;
        }
        return false;
    }

    private void readLitString() throws IOException {
        this.token.clearValue();
        int parenthesesDepth = 0;
        byte ch = this.source.readByte();
        while (!this.source.isEOF()) {
            block0 : switch (ch) {
                default: {
                    this.appendToToken(ch);
                    break;
                }
                case 40: {
                    ++parenthesesDepth;
                    this.appendToToken(ch);
                    break;
                }
                case 41: {
                    if (parenthesesDepth == 0) {
                        return;
                    }
                    --parenthesesDepth;
                    this.appendToToken(ch);
                    break;
                }
                case 92: {
                    ch = this.source.readByte();
                    switch (ch) {
                        case 40: {
                            this.appendToToken((byte)40);
                            break block0;
                        }
                        case 41: {
                            this.appendToToken((byte)41);
                            break block0;
                        }
                        case 110: {
                            this.appendToToken((byte)10);
                            break block0;
                        }
                        case 114: {
                            this.appendToToken((byte)13);
                            break block0;
                        }
                        case 116: {
                            this.appendToToken((byte)9);
                            break block0;
                        }
                        case 98: {
                            this.appendToToken((byte)8);
                            break block0;
                        }
                        case 102: {
                            this.appendToToken((byte)12);
                            break block0;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            char ch1 = (char)(ch - 48);
                            for (int i = 1; i < 3; ++i) {
                                ch = this.source.readByte();
                                if (ch < 48 || ch > 55) {
                                    this.source.unread();
                                    break;
                                }
                                ch1 = (char)((ch1 << 3) + (ch - 48));
                            }
                            this.appendToToken(ch1);
                            break block0;
                        }
                        case 10: {
                            break block0;
                        }
                        case 13: {
                            ch = this.source.readByte();
                            if (ch == 10) break block0;
                            this.source.unread();
                            break block0;
                        }
                        default: {
                            this.appendToToken(ch);
                        }
                    }
                }
            }
            ch = this.source.readByte();
        }
    }

    private void readHexString() throws IOException {
        this.token.clearValue();
        int uc = 0;
        boolean containsOnlyHex = true;
        long hexCount = 0L;
        boolean odd = false;
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (ch == 62) {
                if (odd) {
                    this.appendToToken(uc <<= 4);
                }
                this.token.setContainsOnlyHex(containsOnlyHex);
                this.token.setHexCount(hexCount);
                return;
            }
            if (CharTable.isSpace(ch)) continue;
            byte hex = COSFilterASCIIHexDecode.decodeLoHex(ch);
            ++hexCount;
            if (hex < 16 && hex > -1) {
                if (odd) {
                    uc = (uc << 4) + hex;
                    this.appendToToken(uc);
                    uc = 0;
                } else {
                    uc = hex;
                }
                odd = !odd;
                continue;
            }
            containsOnlyHex = false;
        }
        this.token.setContainsOnlyHex(containsOnlyHex);
        this.token.setHexCount(hexCount);
    }

    private void readASCII85() throws IOException {
        long ascii85Start = this.source.getOffset();
        long ascii85End = this.source.getStreamLength();
        byte b = this.source.readByte();
        while (!this.source.isEOF()) {
            if (b == 126 && this.source.peek() == 62) {
                ascii85End = this.source.getOffset() - 1L;
                this.source.readByte();
                break;
            }
            b = this.source.readByte();
        }
        ASInputStream ascii85 = this.source.getStream(ascii85Start, ascii85End - ascii85Start);
        COSFilterASCII85Decode ascii85Decode = new COSFilterASCII85Decode(ascii85);
        byte[] buf = new byte[(int)(ascii85End - ascii85Start)];
        int read = ascii85Decode.read(buf);
        buf = Arrays.copyOf(buf, read);
        this.token.setContainsOnlyHex(false);
        this.token.setHexCount(0L);
        this.token.setByteValue(buf);
    }

    protected void readName() throws IOException {
        this.token.clearValue();
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (CharTable.isTokenDelimiter(ch)) {
                this.source.unread();
                break;
            }
            if (ch == 35) {
                byte ch1 = this.source.readByte();
                if (!this.source.isEOF() && COSFilterASCIIHexDecode.decodeLoHex(ch1) != 127) {
                    byte dc = COSFilterASCIIHexDecode.decodeLoHex(ch1);
                    byte ch2 = this.source.readByte();
                    if (!this.source.isEOF() && COSFilterASCIIHexDecode.decodeLoHex(ch2) != 127) {
                        dc = (byte)((dc << 4) + COSFilterASCIIHexDecode.decodeLoHex(ch2));
                        this.appendToToken(dc);
                        continue;
                    }
                    this.appendToToken(ch);
                    this.appendToToken(ch1);
                    this.source.unread();
                    continue;
                }
                this.appendToToken(ch);
                this.source.unread();
                continue;
            }
            this.appendToToken(ch);
        }
    }

    private void readToken() throws IOException {
        this.token.clearValue();
        while (!this.source.isEOF()) {
            byte ch = this.source.readByte();
            if (CharTable.isTokenDelimiter(ch)) {
                this.source.unread();
                break;
            }
            this.appendToToken(ch);
        }
    }

    protected void readNumber() throws IOException {
        try {
            this.initializeToken();
            this.token.clearValue();
            this.token.type = Token.Type.TT_INTEGER;
            while (!this.source.isEOF()) {
                byte ch = this.source.readByte();
                if (CharTable.isTokenDelimiter(ch)) {
                    this.source.unread();
                    break;
                }
                if (ch >= 48 && ch <= 57) {
                    this.appendToToken(ch);
                    continue;
                }
                if (ch == 46) {
                    this.token.type = Token.Type.TT_REAL;
                    this.appendToToken(ch);
                    continue;
                }
                this.source.unread();
                break;
            }
            if (this.token.type == Token.Type.TT_INTEGER) {
                long value;
                this.token.integer = value = Long.valueOf(this.token.getValue()).longValue();
                this.token.real = value;
            } else {
                double value = Double.valueOf(this.token.getValue());
                this.token.integer = Math.round(value);
                this.token.real = value;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.FINE, "", e);
            this.token.integer = Math.round(Double.MAX_VALUE);
            this.token.real = Double.MAX_VALUE;
        }
    }

    protected void initializeToken() {
        if (this.token == null) {
            this.token = new Token();
        }
    }

    protected void clearToken() {
        this.token.clearValue();
    }

    protected void appendToToken(byte ch) {
        this.token.append((char)(ch & 0xFF));
    }

    private void appendToToken(int ch) {
        this.token.append((char)ch);
    }

    public static byte[] getRawBytes(String string) {
        byte[] res = new byte[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            res[i] = (byte)string.charAt(i);
        }
        return res;
    }

    protected void skipExpectedCharacter(char exp) throws IOException {
        char c = (char)this.source.readByte();
        if (c != exp) {
            throw new IOException("Unexpected character on byte " + (this.source.getOffset() - 1L) + "; expected " + exp + " but got " + c);
        }
    }
}

