/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.opentype.OpenTypeFontProgram;
import org.verapdf.pd.font.truetype.TrueTypeFontProgram;
import org.verapdf.tools.FontProgramIDGenerator;
import org.verapdf.tools.StaticResources;

public class PDTrueTypeFont
extends PDSimpleFont {
    private static final Logger LOGGER = Logger.getLogger(PDTrueTypeFont.class.getCanonicalName());

    public PDTrueTypeFont(COSDictionary dictionary) {
        super(dictionary);
    }

    @Override
    public FontProgram getFontProgram() {
        if (!this.isFontParsed) {
            this.isFontParsed = true;
            if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE2)) {
                this.parseTrueTypeFontProgram(ASAtom.FONT_FILE2);
            } else if (this.fontDescriptor.canParseFontFile(ASAtom.FONT_FILE3)) {
                this.parseTrueTypeFontProgram(ASAtom.FONT_FILE3);
            } else {
                this.fontProgram = null;
            }
        }
        return this.fontProgram;
    }

    private void parseTrueTypeFontProgram(ASAtom fontFileType) {
        block31: {
            COSStream trueTypeFontFile = null;
            if (fontFileType == ASAtom.FONT_FILE2) {
                trueTypeFontFile = this.fontDescriptor.getFontFile2();
            } else if (fontFileType == ASAtom.FONT_FILE3) {
                trueTypeFontFile = this.fontDescriptor.getFontFile3();
            }
            if (trueTypeFontFile != null) {
                COSKey key = trueTypeFontFile.getObjectKey();
                boolean isSymbolic = this.isSymbolic();
                COSObject encoding = this.getEncoding();
                try {
                    if (fontFileType == ASAtom.FONT_FILE2) {
                        String fontProgramID = FontProgramIDGenerator.getTrueTypeFontProgramID(key, isSymbolic, encoding);
                        this.fontProgram = StaticResources.getCachedFont(fontProgramID);
                        if (this.fontProgram != null) break block31;
                        try (ASInputStream fontData = trueTypeFontFile.getData(COSStream.FilterFlags.DECODE);){
                            this.fontProgram = new TrueTypeFontProgram(fontData, isSymbolic, encoding);
                            StaticResources.cacheFontProgram(fontProgramID, this.fontProgram);
                            break block31;
                        }
                    }
                    boolean isSubset = this.isSubset();
                    String fontProgramID = FontProgramIDGenerator.getOpenTypeFontProgramID(key, false, isSymbolic, encoding, null, isSubset);
                    this.fontProgram = StaticResources.getCachedFont(fontProgramID);
                    if (this.fontProgram != null) break block31;
                    try (ASInputStream fontData = trueTypeFontFile.getData(COSStream.FilterFlags.DECODE);){
                        this.fontProgram = new OpenTypeFontProgram(fontData, false, isSymbolic, encoding, null, isSubset);
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Can't read TrueType font program.", e);
                }
            }
        }
    }

    @Override
    public float getWidthFromProgram(int code) {
        return this.getFontProgram().getWidth(code);
    }

    @Override
    public boolean glyphIsPresent(int code) {
        return this.getFontProgram().containsCode(code);
    }
}

