/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.as.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.tools.IntReference;

public class ASMemoryInStream
extends SeekableInputStream {
    private int bufferSize;
    private int currentPosition;
    private byte[] buffer;
    private boolean copiedBuffer;
    private int resetPosition = 0;
    private IntReference numOfBufferUsers;

    public ASMemoryInStream(byte[] buffer) {
        this(buffer, buffer.length);
    }

    public ASMemoryInStream(InputStream stream) throws IOException {
        int bytesRead;
        this.currentPosition = 0;
        this.copiedBuffer = true;
        byte[] buffer = new byte[8192];
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        while ((bytesRead = stream.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
        }
        this.buffer = output.toByteArray();
        this.bufferSize = this.buffer.length;
        this.numOfBufferUsers = new IntReference(1);
    }

    public ASMemoryInStream(ASMemoryInStream stream, int offset, int length) {
        this.buffer = stream.buffer;
        this.copiedBuffer = false;
        this.currentPosition = offset >= 0 && offset < stream.bufferSize ? offset : 0;
        this.resetPosition = this.currentPosition;
        this.bufferSize = Math.min(stream.bufferSize, offset + length);
        this.numOfBufferUsers = stream.numOfBufferUsers;
        this.numOfBufferUsers.increment();
    }

    public ASMemoryInStream(byte[] buffer, int bufferSize) {
        this(buffer, bufferSize, true);
    }

    public ASMemoryInStream(byte[] buffer, int bufferSize, boolean copyBuffer) {
        this.bufferSize = bufferSize;
        this.currentPosition = 0;
        this.copiedBuffer = copyBuffer;
        if (copyBuffer) {
            this.buffer = Arrays.copyOf(buffer, bufferSize);
            this.numOfBufferUsers = new IntReference(1);
        } else {
            this.buffer = buffer;
            this.numOfBufferUsers = new IntReference(2);
        }
    }

    @Override
    public int read(byte[] buffer, int size) throws IOException {
        if (this.currentPosition == this.bufferSize) {
            return -1;
        }
        int available = Math.min(this.bufferSize - this.currentPosition, size);
        try {
            System.arraycopy(this.buffer, this.currentPosition, buffer, 0, available);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IOException("Can't write bytes into passed buffer: too small.");
        }
        this.currentPosition += available;
        return available;
    }

    @Override
    public int read() throws IOException {
        if (this.currentPosition == this.bufferSize) {
            return -1;
        }
        return this.buffer[this.currentPosition++] & 0xFF;
    }

    @Override
    public int peek() throws IOException {
        if (this.currentPosition == this.bufferSize) {
            return -1;
        }
        return this.buffer[this.currentPosition] & 0xFF;
    }

    @Override
    public int skip(int size) throws IOException {
        int available = Math.min(this.bufferSize - this.currentPosition, size);
        this.currentPosition += available;
        return available;
    }

    @Override
    public void closeResource() throws IOException {
        if (!this.isSourceClosed) {
            this.isSourceClosed = true;
            this.numOfBufferUsers.decrement();
            if (this.numOfBufferUsers.equals(0)) {
                this.buffer = null;
            }
        }
    }

    @Override
    public void reset() throws IOException {
        this.currentPosition = this.resetPosition;
    }

    @Override
    public long getStreamLength() throws IOException {
        return this.bufferSize;
    }

    @Override
    public long getOffset() throws IOException {
        return this.currentPosition;
    }

    @Override
    public void seek(long offset) throws IOException {
        if (offset < 0L || offset > (long)this.bufferSize) {
            throw new IOException("Can't seek for offset " + offset + " in ASMemoryInStream");
        }
        this.currentPosition = (int)offset;
    }

    @Override
    public int available() {
        return this.bufferSize - this.currentPosition;
    }

    public boolean isCopiedBuffer() {
        return this.copiedBuffer;
    }

    @Override
    public ASInputStream getStream(long startOffset, long length) throws IOException {
        if (startOffset > 0L && startOffset < (long)this.bufferSize && startOffset + length <= (long)this.bufferSize) {
            return new ASMemoryInStream(this, (int)startOffset, (int)length);
        }
        throw new IOException();
    }
}

