/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.io.ASConcatenatedInputStream;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSBasePair;
import org.verapdf.cos.COSDirect;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.visitor.ICOSVisitor;
import org.verapdf.cos.visitor.IVisitor;

public class COSArray
extends COSDirect
implements Iterable<COSObject> {
    private static final Logger LOGGER = Logger.getLogger(COSArray.class.getCanonicalName());
    private List<COSObject> entries;

    protected COSArray() {
        this.entries = new ArrayList<COSObject>();
    }

    protected COSArray(int size, COSObject[] values) {
        this.entries = Arrays.asList(values);
    }

    protected COSArray(int size, double[] values) {
        this.entries = new ArrayList<COSObject>();
        for (double value : values) {
            this.entries.add(COSReal.construct(value));
        }
    }

    protected COSArray(int i, COSObject object) {
        this.entries = new ArrayList<COSObject>();
        this.entries.add(i, object);
    }

    protected COSArray(int size) {
        this.entries = new ArrayList<COSObject>(size);
    }

    @Override
    public COSObjType getType() {
        return COSObjType.COS_ARRAY;
    }

    public static COSObject construct() {
        return new COSObject(new COSArray());
    }

    public static COSObject construct(int size, COSObject[] value) {
        return new COSObject(new COSArray(size, value));
    }

    public static COSObject construct(int size, double[] value) {
        return new COSObject(new COSArray(size, value));
    }

    public static COSObject construct(int i, COSObject obj) {
        return new COSObject(new COSArray(i, obj));
    }

    public static COSObject construct(int size) {
        return new COSObject(new COSArray(size));
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitFromArray(this);
    }

    @Override
    public Object accept(ICOSVisitor visitor) {
        return visitor.visitFromArray(this);
    }

    @Override
    public Integer size() {
        return this.entries.size();
    }

    @Override
    public Iterator<COSObject> iterator() {
        return this.entries.iterator();
    }

    @Override
    public COSObject at(int i) {
        if (i >= this.entries.size()) {
            return new COSObject();
        }
        return this._at(i);
    }

    @Override
    public boolean add(COSObject value) {
        this.entries.add(value);
        return true;
    }

    @Override
    public boolean set(int i, COSObject value) {
        this.entries.set(i, value);
        return true;
    }

    @Override
    public boolean insert(int i, COSObject value) {
        this.entries.add(i, value);
        return true;
    }

    @Override
    public void remove(int i) {
        if (this.entries.size() > i) {
            this.entries.remove(i);
        }
    }

    @Override
    public boolean setArray() {
        this.entries.clear();
        return true;
    }

    @Override
    public boolean setArray(int size, COSObject[] value) {
        this.entries.addAll(Arrays.asList(value));
        return true;
    }

    @Override
    public boolean setArray(int size, double[] values) {
        this.entries.clear();
        for (double value : values) {
            this.entries.add(COSReal.construct(value));
        }
        return true;
    }

    @Override
    public void clearArray() {
        this.entries.clear();
    }

    private COSObject _at(int i) {
        return this.entries.get(i);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof COSObject) {
            return this.equals(((COSObject)obj).get());
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LinkedList<COSBasePair> checkedObjects = new LinkedList<COSBasePair>();
        return this.equals(obj, checkedObjects);
    }

    @Override
    boolean equals(Object obj, List<COSBasePair> checkedObjects) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof COSObject) {
            return this.equals(((COSObject)obj).get());
        }
        if (COSBasePair.listContainsPair(checkedObjects, this, (COSBase)obj)) {
            return true;
        }
        COSBasePair.addPairToList(checkedObjects, this, (COSBase)obj);
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        COSArray that = (COSArray)obj;
        if (!that.size().equals(this.size())) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            COSBase cosBase2;
            COSBase cosBase1 = this.at(i).getDirectBase();
            if (cosBase1.equals(cosBase2 = that.at(i).getDirectBase(), checkedObjects)) continue;
            return false;
        }
        return true;
    }

    @Override
    public ASInputStream getData(COSStream.FilterFlags flags) {
        ArrayList<ASInputStream> streams = new ArrayList<ASInputStream>();
        try {
            for (COSObject object : this.entries) {
                if (object.getType() != COSObjType.COS_STREAM) continue;
                streams.add(object.getData(flags));
            }
        }
        catch (Exception any) {
            for (ASInputStream stream : streams) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Error in closing stream", e);
                }
            }
            throw any;
        }
        return new ASConcatenatedInputStream(streams);
    }

    @Override
    public ASInputStream getData() {
        return this.getData(COSStream.FilterFlags.RAW_DATA);
    }
}

