/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.cos;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBody;
import org.verapdf.cos.COSHeader;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSTrailer;
import org.verapdf.cos.visitor.Writer;
import org.verapdf.cos.xref.COSXRefTable;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.io.IReader;
import org.verapdf.io.InternalInputStream;
import org.verapdf.io.Reader;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.encryption.StandardSecurityHandler;
import org.verapdf.tools.resource.ASFileStreamCloser;
import org.verapdf.tools.resource.FileResourceHandler;

public class COSDocument {
    private static final Logger LOGGER = Logger.getLogger(COSDocument.class.getCanonicalName());
    private PDDocument doc;
    private IReader reader;
    private COSHeader header;
    private COSBody body;
    private COSXRefTable xref;
    private COSTrailer trailer;
    private COSTrailer firstTrailer;
    private COSTrailer lastTrailer;
    private boolean linearized;
    private boolean isNew;
    private StandardSecurityHandler standardSecurityHandler;
    private List<COSObject> changedObjects;
    private List<COSObject> addedObjects;
    private FileResourceHandler resourceHandler;
    private byte postEOFDataSize;
    private boolean xrefEOLMarkersComplyPDFA = true;
    private boolean subsectionHeaderSpaceSeparated = true;

    public COSDocument(PDDocument document) {
        this.doc = document;
        this.header = new COSHeader();
        this.body = new COSBody();
        this.xref = new COSXRefTable();
        this.trailer = new COSTrailer();
        this.firstTrailer = new COSTrailer();
        this.lastTrailer = new COSTrailer();
        this.linearized = false;
        this.isNew = true;
        this.changedObjects = new ArrayList<COSObject>();
        this.addedObjects = new ArrayList<COSObject>();
        this.resourceHandler = new FileResourceHandler();
    }

    public COSDocument(String fileName, PDDocument document) throws IOException {
        this.resourceHandler = new FileResourceHandler();
        this.initReader(fileName);
        this.initCOSDocument(document);
    }

    public COSDocument(InputStream fileStream, PDDocument document) throws IOException {
        this.resourceHandler = new FileResourceHandler();
        this.initReader(fileStream);
        this.initCOSDocument(document);
    }

    private void initCOSDocument(PDDocument document) {
        this.doc = document;
        this.body = new COSBody();
        this.header = this.reader.getHeader();
        this.xref = new COSXRefTable();
        this.xref.set(this.reader.getKeys());
        this.trailer = this.reader.getTrailer();
        this.firstTrailer = this.reader.getFirstTrailer();
        this.lastTrailer = this.reader.getLastTrailer();
        this.linearized = this.reader.isLinearized();
        this.changedObjects = new ArrayList<COSObject>();
        this.addedObjects = new ArrayList<COSObject>();
    }

    private void initReader(InputStream fileStream) throws IOException {
        this.reader = new Reader(this, fileStream);
        this.resourceHandler.addResource(this.reader);
    }

    private void initReader(String fileName) throws IOException {
        this.reader = new Reader(this, fileName);
        this.resourceHandler.addResource(this.reader);
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setHeader(String header) {
        this.header.setHeader(header);
    }

    public List<COSObject> getObjects() {
        ArrayList<COSObject> result = new ArrayList<COSObject>();
        for (COSKey key : this.xref.getAllKeys()) {
            COSObject obj = this.body.get(key);
            if (!obj.empty()) {
                result.add(obj);
                continue;
            }
            try {
                COSObject newObj = this.reader.getObject(key);
                this.body.set(key, newObj);
                result.add(newObj);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error while parsing object : " + key.getNumber() + " " + key.getGeneration(), e);
            }
            catch (StackOverflowError e) {
                throw new LoopedException("Loop in getting object from reader", e);
            }
        }
        return result;
    }

    public List<COSObject> getObjectsByType(ASAtom type) {
        ArrayList<COSObject> result = new ArrayList<COSObject>();
        for (COSKey key : this.xref.getAllKeys()) {
            COSObject obj = this.body.get(key);
            if (!obj.empty()) {
                COSDocument.addObjectWithTypeKeyCheck(result, obj, type);
                continue;
            }
            try {
                COSObject newObj = this.reader.getObject(key);
                this.body.set(key, newObj);
                COSDocument.addObjectWithTypeKeyCheck(result, obj, type);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error while parsing object : " + key.getNumber() + " " + key.getGeneration(), e);
            }
        }
        return result;
    }

    private static void addObjectWithTypeKeyCheck(List<COSObject> objects, COSObject obj, ASAtom type) {
        ASAtom actualType;
        if (obj != null && !obj.empty() && obj.getType().isDictionaryBased() && (actualType = obj.getNameKey(ASAtom.TYPE)) == type) {
            objects.add(obj);
        }
    }

    public Map<COSKey, COSObject> getObjectsMap() {
        HashMap<COSKey, COSObject> result = new HashMap<COSKey, COSObject>();
        for (COSKey key : this.xref.getAllKeys()) {
            COSObject obj = this.body.get(key);
            if (!obj.empty()) {
                result.put(key, obj);
                continue;
            }
            try {
                COSObject newObj = this.reader.getObject(key);
                this.body.set(key, newObj);
                result.put(key, newObj);
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Error while parsing object : " + key.getNumber() + " " + key.getGeneration(), e);
            }
        }
        return result;
    }

    public COSObject getObject(COSKey key) {
        try {
            COSObject obj = this.body.get(key);
            if (!obj.empty()) {
                return obj;
            }
            COSObject newObj = this.reader.getObject(key);
            if (newObj == null) {
                return new COSObject();
            }
            this.body.set(key, newObj);
            return this.body.get(key);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while parsing object : " + key.getNumber() + " " + key.getGeneration(), e);
        }
    }

    public Long getOffset(COSKey key) {
        return this.reader.getOffset(key);
    }

    public void setObject(COSKey key, COSObject obj) {
        this.body.set(key, obj);
        this.xref.newKey(key);
    }

    public COSKey setObject(COSObject obj) {
        COSKey key = obj.getKey();
        if (key == null) {
            key = this.xref.next();
            this.body.set(key, obj.isIndirect() != false ? obj.getDirect() : obj);
            obj = COSIndirect.construct(key, this);
        }
        this.xref.newKey(key);
        return key;
    }

    public COSTrailer getTrailer() {
        return this.trailer;
    }

    public COSTrailer getFirstTrailer() {
        return this.firstTrailer;
    }

    public COSTrailer getLastTrailer() {
        return this.lastTrailer;
    }

    public boolean isLinearized() {
        return this.linearized;
    }

    public PDDocument getPDDocument() {
        return this.doc;
    }

    public COSHeader getHeader() {
        return this.header;
    }

    public void setHeader(COSHeader header) {
        this.header = header;
    }

    public byte getPostEOFDataSize() {
        return this.postEOFDataSize;
    }

    public void setPostEOFDataSize(byte postEOFDataSize) {
        this.postEOFDataSize = postEOFDataSize;
    }

    public boolean isXrefEOLMarkersComplyPDFA() {
        return this.xrefEOLMarkersComplyPDFA;
    }

    public void setXrefEOLMarkersComplyPDFA(boolean xrefEOLMarkersComplyPDFA) {
        this.xrefEOLMarkersComplyPDFA = xrefEOLMarkersComplyPDFA;
    }

    public boolean isSubsectionHeaderSpaceSeparated() {
        return this.subsectionHeaderSpaceSeparated;
    }

    public void setSubsectionHeaderSpaceSeparated(boolean subsectionHeaderSpaceSeparated) {
        this.subsectionHeaderSpaceSeparated = subsectionHeaderSpaceSeparated;
    }

    public void save() {
    }

    public SeekableInputStream getPDFSource() {
        return this.reader.getPDFSource();
    }

    public void saveAs(Writer writer) {
        writer.writeHeader(this.header.getHeader());
        writer.addToWrite(this.xref.getAllKeys());
        writer.writeBody();
        writer.setTrailer(this.trailer);
        writer.writeXRefInfo();
        writer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveTo(OutputStream stream) {
        File temp = null;
        try {
            temp = File.createTempFile("tmp_pdf_file", ".pdf");
            Writer pdfWriter = new Writer(this, temp.getAbsolutePath(), this.getPDFSource().getStreamLength());
            pdfWriter.writeIncrementalUpdate(this.changedObjects, this.addedObjects);
            pdfWriter.close();
            this.getPDFSource().reset();
            COSDocument.writeInputIntoOutput(this.getPDFSource(), stream);
            InternalInputStream pdf = new InternalInputStream(temp.getAbsolutePath());
            COSDocument.writeInputIntoOutput(pdf, stream);
            pdf.close();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Can't write COSDocument to stream", e);
        }
        finally {
            if (temp != null && !temp.delete()) {
                temp.deleteOnExit();
            }
        }
    }

    private static void writeInputIntoOutput(InputStream input, OutputStream output) throws IOException {
        byte[] buf = new byte[2048];
        int read = input.read(buf, 0, buf.length);
        while (read != -1) {
            output.write(buf, 0, read);
            read = input.read(buf, 0, buf.length);
        }
    }

    public void setStandardSecurityHandler(StandardSecurityHandler standardSecurityHandler) {
        this.standardSecurityHandler = standardSecurityHandler;
    }

    public StandardSecurityHandler getStandardSecurityHandler() {
        return this.standardSecurityHandler;
    }

    public boolean isEncrypted() {
        return this.standardSecurityHandler != null;
    }

    public COSArray getID() {
        COSObject res;
        if (this.trailer != null && (res = this.trailer.getKey(ASAtom.ID)).getType() == COSObjType.COS_ARRAY) {
            return (COSArray)res.getDirectBase();
        }
        return null;
    }

    public void addObject(COSObject obj) {
        if (obj != null && !obj.empty()) {
            this.addedObjects.add(obj);
        }
    }

    public void removeAddedObject(COSObject obj) {
        this.addedObjects.remove(obj);
    }

    public void addChangedObject(COSObject obj) {
        if (obj != null && !obj.empty() && !this.isObjectChanged(obj)) {
            this.changedObjects.add(obj);
        }
    }

    public void removeChangedObject(COSObject obj) {
        this.changedObjects.remove(obj);
    }

    public boolean isObjectChanged(COSObject obj) {
        return COSDocument.listContainsObject(this.changedObjects, obj) || COSDocument.listContainsObject(this.addedObjects, obj);
    }

    private static boolean listContainsObject(List<COSObject> list, COSObject obj) {
        for (COSObject listObject : list) {
            if (listObject != obj) continue;
            return true;
        }
        return false;
    }

    public long getLastTrailerOffset() {
        return this.reader.getLastTrailerOffset();
    }

    public int getLastKeyNumber() {
        return this.reader.getGreatestKeyNumberFromXref();
    }

    public boolean isReaderInitialized() {
        return this.reader != null;
    }

    public void addFileResource(ASFileStreamCloser resource) {
        this.resourceHandler.addResource(resource);
    }

    public FileResourceHandler getResourceHandler() {
        return this.resourceHandler;
    }

    public SortedSet<Long> getStartXRefs() {
        return this.reader.getStartXRefs();
    }
}

