/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.truetype.TrueTypeCmapSubtable;
import org.verapdf.pd.font.truetype.TrueTypeTable;

class TrueTypeCmapTable
extends TrueTypeTable {
    private TrueTypeCmapSubtable[] cmapInfos;

    TrueTypeCmapTable(SeekableInputStream source, long offset) {
        super(source, offset);
    }

    TrueTypeCmapSubtable[] getCmapInfos() {
        return this.cmapInfos;
    }

    @Override
    void readTable() throws IOException {
        long startingOffset = this.source.getOffset();
        this.source.seek(this.offset);
        this.source.skip(2);
        int numberOfTables = this.readUShort();
        this.cmapInfos = new TrueTypeCmapSubtable[numberOfTables];
        for (int i = 0; i < numberOfTables; ++i) {
            this.cmapInfos[i] = new TrueTypeCmapSubtable(this.readUShort(), this.readUShort(), this.readULong());
        }
        block7: for (TrueTypeCmapSubtable cmap : this.cmapInfos) {
            this.source.seek(cmap.getOffset() + this.offset);
            int format = this.readUShort();
            switch (format) {
                case 0: {
                    this.readByteEncodingTable(cmap);
                    continue block7;
                }
                case 2: {
                    this.readHighByteMapping(cmap);
                    continue block7;
                }
                case 4: {
                    this.readSegmentMapping(cmap);
                    continue block7;
                }
                case 6: {
                    this.readTrimmedTableMapping(cmap);
                }
            }
        }
        this.source.seek(startingOffset);
    }

    private void readByteEncodingTable(TrueTypeCmapSubtable cmap) throws IOException {
        this.source.skip(4);
        for (int i = 0; i < 256; ++i) {
            cmap.put(i, this.readByte());
        }
    }

    private void readHighByteMapping(TrueTypeCmapSubtable cmap) throws IOException {
    }

    private void readSegmentMapping(TrueTypeCmapSubtable cmap) throws IOException {
        this.source.skip(4);
        int segCount = this.readUShort() / 2;
        this.source.skip(6);
        int[] endCode = new int[segCount];
        int[] startCode = new int[segCount];
        int[] idDelta = new int[segCount];
        int[] idRangeOffset = new int[segCount];
        long idRangeOffsetBegin = this.initSegmentMapping(endCode, startCode, idDelta, idRangeOffset, segCount);
        for (int i = 0; i < segCount; ++i) {
            int j;
            if (idRangeOffset[i] == 0) {
                for (j = startCode[i]; j <= endCode[i]; ++j) {
                    cmap.put(j, (idDelta[i] + j) % 65536);
                }
                continue;
            }
            if (startCode[i] == 65535 || endCode[i] == 65535) continue;
            for (j = 0; j <= endCode[i] - startCode[i]; ++j) {
                long glyphOffset = idRangeOffsetBegin + (long)((idRangeOffset[i] / 2 + j + (i - segCount)) * 2);
                this.source.seek(glyphOffset);
                int glyphCode = this.readUShort();
                if (glyphCode != 0) {
                    glyphCode = (glyphCode + idDelta[i]) % 65536;
                }
                cmap.put(j + startCode[i], glyphCode);
            }
        }
    }

    private long initSegmentMapping(int[] endCode, int[] startCode, int[] idDelta, int[] idRangeOffset, int segCount) throws IOException {
        int i;
        for (i = 0; i < segCount; ++i) {
            endCode[i] = this.readUShort();
        }
        this.source.skip(2);
        for (i = 0; i < segCount; ++i) {
            startCode[i] = this.readUShort();
        }
        for (i = 0; i < segCount; ++i) {
            idDelta[i] = this.readUShort();
        }
        for (i = 0; i < segCount; ++i) {
            idRangeOffset[i] = this.readUShort();
        }
        return this.source.getOffset();
    }

    private void readTrimmedTableMapping(TrueTypeCmapSubtable cmap) throws IOException {
        this.source.skip(4);
        int firstCode = this.readUShort();
        int entryCount = this.readUShort();
        for (int i = 0; i < entryCount; ++i) {
            cmap.put(firstCode + i, this.readUShort());
        }
    }

    public int getGID(int code) {
        for (TrueTypeCmapSubtable ttcs : this.cmapInfos) {
            if (!ttcs.containsCID(code)) continue;
            return ttcs.getGlyph(code);
        }
        return 0;
    }
}

