/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSNumber;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.fonts.PDFontFactory;
import org.verapdf.pd.PDHalftone;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.function.PDFunction;

public class PDExtGState
extends PDResource {
    private static final Logger LOGGER = Logger.getLogger(PDExtGState.class.getCanonicalName());

    public PDExtGState(COSObject obj) {
        super(obj);
    }

    public Boolean getAlphaSourceFlag() {
        return this.getBooleanKey(ASAtom.AIS);
    }

    public Boolean getAutomaticStrokeAdjustment() {
        return this.getBooleanKey(ASAtom.SA);
    }

    public Boolean getStrokingOverprintControl() {
        return this.getBooleanKey(ASAtom.OP);
    }

    public Boolean getNonStrokingOverprintControl() {
        Boolean opNS = this.getBooleanKey(ASAtom.OP_NS);
        return opNS == null ? this.getBooleanKey(ASAtom.OP) : opNS;
    }

    public Long getOverprintMode() {
        return this.getIntegerKey(ASAtom.OPM);
    }

    public COSObject getCOSTR() {
        return this.getKey(ASAtom.TR);
    }

    public COSObject getCOSTR2() {
        return this.getKey(ASAtom.TR2);
    }

    public COSObject getCOSSMask() {
        return this.getKey(ASAtom.SMASK);
    }

    public COSObject getCOSBM() {
        return this.getKey(ASAtom.BM);
    }

    public COSObject getCA() {
        return this.getKey(ASAtom.CA);
    }

    public COSObject getCA_NS() {
        return this.getKey(ASAtom.CA_NS);
    }

    public COSName getCOSRenderingIntentName() {
        COSObject name = this.getKey(ASAtom.RI);
        if (name != null && name.getType() == COSObjType.COS_NAME) {
            return (COSName)name.getDirectBase();
        }
        return null;
    }

    public COSNumber getCOSFontSize() {
        COSObject res;
        COSObject fontArray = this.getKey(ASAtom.FONT);
        if (fontArray != null && fontArray.getType() == COSObjType.COS_ARRAY && (res = fontArray.at(1)) != null && res.getType().isNumber()) {
            return (COSNumber)res.getDirectBase();
        }
        return null;
    }

    public PDHalftone getHalftone() {
        COSObject obj = this.getKey(ASAtom.HT);
        if (obj != null && (obj.getType() == COSObjType.COS_NAME || obj.getType() == COSObjType.COS_DICT || obj.getType() == COSObjType.COS_STREAM)) {
            return new PDHalftone(obj);
        }
        return null;
    }

    public COSObject getHalftonePhase() {
        return this.getKey(ASAtom.HTP);
    }

    public PDFont getFont() {
        COSObject res;
        COSObject fontArray = this.getKey(ASAtom.FONT);
        if (fontArray != null && fontArray.getType() == COSObjType.COS_ARRAY && (res = fontArray.at(0)) != null && res.getType().isDictionaryBased()) {
            return PDFontFactory.getPDFont(res);
        }
        return null;
    }

    public List<PDFunction> getTRFunctions() {
        return this.getFunctions(ASAtom.TR);
    }

    public List<PDFunction> getTR2Functions() {
        return this.getFunctions(ASAtom.TR2);
    }

    private List<PDFunction> getFunctions(ASAtom atom) {
        COSObject functions = this.getKey(atom);
        if (functions.getType() == COSObjType.COS_STREAM) {
            PDFunction function = PDFunction.createFunction(functions);
            if (function != null) {
                return Collections.singletonList(function);
            }
        } else if (functions.getType() == COSObjType.COS_ARRAY) {
            if (functions.size() != 4) {
                LOGGER.warning("Transfer function array must contain exactly 4 elements");
            }
            ArrayList<PDFunction> resultList = new ArrayList<PDFunction>();
            for (int i = 0; i < functions.size(); ++i) {
                PDFunction function = PDFunction.createFunction(functions.at(i));
                if (function == null) continue;
                resultList.add(function);
            }
            return Collections.unmodifiableList(resultList);
        }
        return Collections.emptyList();
    }
}

