/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cmap;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.font.cmap.CIDMappable;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.cmap.CMapFactory;

public class CMapFile {
    private static final Logger LOGGER = Logger.getLogger(CMapFile.class.getCanonicalName());
    private CMap cMap;
    private COSStream parentStream;

    public CMapFile(COSStream parentStream) {
        this.parentStream = parentStream;
    }

    public int getDictWMode() {
        Long wMode = this.parentStream.getIntegerKey(ASAtom.W_MODE);
        return wMode == null ? 0 : wMode.intValue();
    }

    public int getWMode() {
        if (this.cMap == null) {
            this.parseCMapFile();
        }
        return this.cMap.getwMode();
    }

    public int getMaxCID() {
        if (this.cMap == null) {
            this.parseCMapFile();
        }
        List<CIDMappable> cidMapings = this.cMap.getCidMappings();
        int res = 0;
        for (CIDMappable cidMappable : cidMapings) {
            if (cidMappable.getMaxCID() <= res) continue;
            res = cidMappable.getMaxCID();
        }
        return res;
    }

    private void parseCMapFile() {
        String cMapName = this.parentStream.getStringKey(ASAtom.CMAPNAME);
        try (ASInputStream data = this.parentStream.getData(COSStream.FilterFlags.DECODE);){
            this.cMap = CMapFactory.getCMap(cMapName == null ? "" : cMapName, data);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception while parsing cmap file", e);
        }
    }
}

