/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.function;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.function.PDFunction;

public class PDType3Function
extends PDFunction {
    private COSArray domain = this.getDomain();
    private List<COSObject> subdomains = this.getSubdomains();
    private List<PDFunction> functions = this.getFunctions();
    private static final Logger LOGGER = Logger.getLogger(PDType3Function.class.getCanonicalName());

    protected PDType3Function(COSObject obj) {
        super(obj);
    }

    public void setSubdomains(List<COSObject> subdomains) {
        this.subdomains = subdomains;
        ArrayList<COSObject> dom = new ArrayList<COSObject>();
        dom.add(subdomains.get(0));
        dom.add(subdomains.get(subdomains.size() - 1));
        this.domain = new COSArray(dom);
    }

    public void setFunctions(List<PDFunction> functions) {
        this.functions = functions;
    }

    public List<COSObject> getSubdomains() {
        if (this.subdomains == null) {
            if (this.domain == null) {
                LOGGER.log(Level.WARNING, "Invalid Domain key value in Type 3 Function dictionary");
                return null;
            }
            COSArray bounds = this.getCOSArray(ASAtom.BOUNDS);
            this.subdomains = new ArrayList<COSObject>();
            this.subdomains.add(this.domain.at(0));
            if (bounds != null) {
                for (COSObject bound : bounds) {
                    this.subdomains.add(bound);
                }
            }
            this.subdomains.add(this.domain.at(1));
        }
        return this.subdomains;
    }

    public COSArray getEncode() {
        COSArray encode = this.getCOSArray(ASAtom.ENCODE);
        List<COSObject> subdomains = this.getSubdomains();
        if (encode == null) {
            ArrayList<COSObject> encodeFromSubdomains = new ArrayList<COSObject>();
            for (int i = 0; i < subdomains.size() - 1; ++i) {
                encodeFromSubdomains.add(subdomains.get(i));
                encodeFromSubdomains.add(subdomains.get(i + 1));
            }
            encode = new COSArray(encodeFromSubdomains);
        }
        return encode;
    }

    public List<PDFunction> getFunctions() {
        if (this.functions == null) {
            COSObject obj = this.getKey(ASAtom.FUNCTIONS);
            if (obj == null || obj.getType() != COSObjType.COS_ARRAY) {
                LOGGER.log(Level.WARNING, "Invalid Functions key value in Type 3 Function dictionary");
                return Collections.emptyList();
            }
            ArrayList<PDFunction> pdFunctions = new ArrayList<PDFunction>();
            for (int i = 0; i < obj.size(); ++i) {
                PDFunction function = PDFunction.createFunction(obj.at(i));
                if (function == null) continue;
                pdFunctions.add(function);
            }
            this.functions = Collections.unmodifiableList(pdFunctions);
        }
        return this.functions;
    }

    public int getIntervalNumber(COSObject x) {
        int functionsCount = this.getSubdomains().size() - 1;
        if (x.getReal().equals(this.getSubdomains().get(0).getReal())) {
            return 0;
        }
        for (int i = 0; i < functionsCount - 1; ++i) {
            if (!(x.getReal() >= this.getSubdomains().get(i).getReal()) || !(x.getReal() < this.getSubdomains().get(i + 1).getReal())) continue;
            return i;
        }
        return functionsCount - 1;
    }

    @Override
    public List<COSObject> getResult(List<COSObject> operands) {
        if (this.subdomains == null) {
            LOGGER.log(Level.WARNING, "Invalid subdomains in Type 3 Function dictionary");
            return null;
        }
        COSArray encode = this.getEncode();
        if (encode.size() < 2 * (this.subdomains.size() - 1)) {
            LOGGER.log(Level.WARNING, "Invalid Encode key value in Type 3 Function dictionary");
            return null;
        }
        if (operands.size() > 1) {
            LOGGER.log(Level.WARNING, "Too many operands. The first one will be chosen");
        }
        List<COSObject> operand = new ArrayList<COSObject>();
        operand.add(operands.get(0));
        operand = this.getValuesInIntervals(operand, this.domain);
        int i = this.getIntervalNumber(operand.get(0));
        operand.set(0, this.interpolate(operand.get(0), this.subdomains.get(i), this.subdomains.get(i + 1), encode.at(2 * i), encode.at(2 * i + 1)));
        return Collections.unmodifiableList(this.getValuesInIntervals(this.getFunctions().get(i).getResult(operand), this.getRange()));
    }
}

