/**
 * This file is part of veraPDF Parser, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Parser is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Parser as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Parser as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.pd.structure;

import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDNameTreeNode;

import java.util.Iterator;

public class NameTreeIterator implements Iterator<COSObject> {

	private NameTreeIterator innerCurrentIterator;
	private final Iterator<COSObject> namesIterator;
	private final Iterator<PDNameTreeNode> kidsIterator;

	public NameTreeIterator(PDNameTreeNode root) {
		namesIterator = root.getNames().values().iterator();
		kidsIterator = root.getKids().iterator();
		nextInnerIterator();
	}

	@Override
	public boolean hasNext() {
		return (innerCurrentIterator != null && innerCurrentIterator.hasNext()) || kidsIterator.hasNext() || namesIterator.hasNext();
	}

	@Override
	public COSObject next() {
		if (namesIterator.hasNext()) {
			return namesIterator.next();
		}
		if (!innerCurrentIterator.hasNext()) {
			nextInnerIterator();
		}
		return innerCurrentIterator.next();
	}

	private void nextInnerIterator() {
		innerCurrentIterator = kidsIterator.hasNext() ? new NameTreeIterator(kidsIterator.next()) : null;
	}
}
