/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSHeader;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.cos.xref.COSXRefInfo;
import org.verapdf.exceptions.InvalidPasswordException;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.parser.DecodedObjectStreamParser;
import org.verapdf.parser.PDFParser;
import org.verapdf.parser.XRefReader;
import org.verapdf.pd.encryption.PDEncryption;
import org.verapdf.pd.encryption.StandardSecurityHandler;
import org.verapdf.tools.resource.FileResourceHandler;

public class Reader
extends XRefReader {
    private static final Logger LOGGER = Logger.getLogger(Reader.class.getCanonicalName());
    private PDFParser parser;
    private COSHeader header;
    private Map<Long, DecodedObjectStreamParser> objectStreams;

    public Reader(COSDocument document, String fileName) throws IOException {
        this.parser = new PDFParser(document, fileName);
        this.objectStreams = new HashMap<Long, DecodedObjectStreamParser>();
        this.init();
    }

    public Reader(COSDocument document, InputStream fileStream) throws IOException {
        this.parser = new PDFParser(document, fileStream);
        this.objectStreams = new HashMap<Long, DecodedObjectStreamParser>();
        this.init();
    }

    @Override
    public COSHeader getHeader() {
        return this.header;
    }

    @Override
    public COSObject getObject(COSKey key) throws IOException {
        COSObject object;
        if (!super.containsKey(key)) {
            LOGGER.log(Level.FINE, "Trying to get object " + key.getNumber() + " " + key.getGeneration() + " that is not present in the document");
            return null;
        }
        long offset = this.getOffset(key);
        if (offset == 0L) {
            return new COSObject();
        }
        if (offset > 0L) {
            if (this.header.getHeaderOffset() > 0L) {
                offset += this.header.getHeaderOffset();
            }
            COSObject result = this.getObject(offset);
            result.setObjectKey(key);
            return result;
        }
        DecodedObjectStreamParser parser = this.objectStreams.get(-offset);
        if (parser != null) {
            return parser.getObject(key);
        }
        COSKey newKey = new COSKey(-((int)offset), 0);
        COSObject cOSObject = object = !newKey.equals(key) ? this.getObject(newKey) : null;
        if (object == null || !object.getType().equals((Object)COSObjType.COS_STREAM)) {
            throw new IOException("Object number " + -offset + " should be object stream, but in fact it is " + (object == null ? "null" : object.getType()));
        }
        COSStream objectStream = (COSStream)object.getDirectBase();
        parser = new DecodedObjectStreamParser(objectStream.getData(COSStream.FilterFlags.DECODE), objectStream, new COSKey((int)(-offset), 0), this.parser.getDocument());
        this.objectStreams.put(-offset, parser);
        return parser.getObject(key);
    }

    @Override
    public COSObject getObject(long offset) throws IOException {
        return this.parser.getObject(offset);
    }

    @Override
    public boolean isLinearized() {
        return this.parser.isLinearized();
    }

    @Override
    public SeekableInputStream getPDFSource() {
        return this.parser.getPDFSource();
    }

    @Override
    public long getLastTrailerOffset() {
        long res = this.parser.getLastTrailerOffset();
        if (res == 0L) {
            LOGGER.log(Level.FINE, "Offset of last trailer can not be determined");
        }
        return res;
    }

    private void init() throws IOException {
        try {
            this.header = this.parser.getHeader();
            ArrayList<COSXRefInfo> infos = new ArrayList<COSXRefInfo>();
            this.parser.getXRefInfo(infos);
            this.setXRefInfo(infos);
            if (this.parser.isEncrypted() && !this.docCanBeDecrypted()) {
                FileResourceHandler handler;
                this.getPDFSource().close();
                if (this.parser.getDocument() != null && (handler = this.parser.getDocument().getResourceHandler()) != null) {
                    handler.close();
                }
                throw new InvalidPasswordException("Reader::init(...)encrypted pdf is not supported");
            }
        }
        catch (IOException e) {
            this.parser.closeInputStream();
            throw e;
        }
    }

    private boolean docCanBeDecrypted() {
        try {
            PDEncryption encryption;
            COSObject cosEncrypt = this.parser.getEncryption();
            if (cosEncrypt.isIndirect().booleanValue()) {
                cosEncrypt = this.parser.getObject(this.getOffset(cosEncrypt.getObjectKey()));
            }
            if ((encryption = new PDEncryption(cosEncrypt)).getFilter() != ASAtom.STANDARD) {
                return false;
            }
            StandardSecurityHandler ssh = new StandardSecurityHandler(encryption, this.getTrailer().getID(), this.parser.getDocument());
            boolean res = ssh.checkPassword();
            if (res) {
                this.parser.getDocument().setStandardSecurityHandler(ssh);
            }
            return res;
        }
        catch (IOException e) {
            LOGGER.log(Level.FINE, "Cannot read object " + this.parser.getEncryption().getObjectKey(), e);
            return false;
        }
    }

    @Override
    public int getGreatestKeyNumberFromXref() {
        int res = 1;
        for (COSKey key : this.getKeys()) {
            if (key.getNumber() <= res) continue;
            res = key.getNumber();
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        if (this.objectStreams != null) {
            for (Map.Entry<Long, DecodedObjectStreamParser> entry : this.objectStreams.entrySet()) {
                entry.getValue().closeInputStream();
            }
        }
    }
}

