/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSDocument;
import org.verapdf.cos.COSIndirect;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDAnnotation;
import org.verapdf.pd.PDContentStream;
import org.verapdf.pd.PDDocument;
import org.verapdf.pd.PDGroup;
import org.verapdf.pd.PDMetadata;
import org.verapdf.pd.PDNavigationNode;
import org.verapdf.pd.PDOutputIntent;
import org.verapdf.pd.PDPageContentStream;
import org.verapdf.pd.PDPageTreeNode;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.actions.PDPageAdditionalActions;
import org.verapdf.pd.annotations.PDWidgetAnnotation;
import org.verapdf.pd.colors.PDColorSpace;

public class PDPage
extends PDPageTreeNode {
    private static final Logger LOGGER = Logger.getLogger(PDPage.class.getCanonicalName());
    public static double[] PAGE_SIZE_A3 = new double[]{0.0, 0.0, 842.0, 1190.0};
    public static double[] PAGE_SIZE_A4 = new double[]{0.0, 0.0, 595.0, 842.0};
    public static double[] PAGE_SIZE_A5 = new double[]{0.0, 0.0, 420.0, 595.0};
    public static double[] PAGE_SIZE_B4 = new double[]{0.0, 0.0, 709.0, 1001.0};
    public static double[] PAGE_SIZE_B5 = new double[]{0.0, 0.0, 499.0, 709.0};
    public static double[] PAGE_SIZE_LETTER = new double[]{0.0, 0.0, 612.0, 1008.0};
    public static double[] PAGE_SIZE_LEGAL = new double[]{0.0, 0.0, 612.0, 792.0};
    private PDResources resources;
    private PDContentStream content;
    int pageNumber = 0;
    int pagesTotal = 0;

    public PDPage(double[] bbox, COSDocument document) {
        COSObject page = COSDictionary.construct();
        page.setNameKey(ASAtom.TYPE, ASAtom.PAGE);
        page.setArrayKey(ASAtom.MEDIA_BOX, 4, bbox);
        page.setArrayKey(ASAtom.CONTENTS);
        COSObject indirect = COSIndirect.construct(page, document);
        this.setObject(indirect);
    }

    public PDPage(COSObject obj) {
        super.setObject(obj);
        this.initializeContents(obj);
    }

    private void initializeContents(COSObject pageDict) {
        COSObject contents = pageDict.getKey(ASAtom.CONTENTS);
        if (contents.getType() == COSObjType.COS_STREAM || contents.getType() == COSObjType.COS_ARRAY) {
            this.content = new PDPageContentStream(contents);
        }
    }

    public double[] getMediaBox() {
        COSArray array = this.getInheritedCOSBBox(ASAtom.MEDIA_BOX);
        if (array != null) {
            return PDPage.getDoubleArrayForBox(array);
        }
        return null;
    }

    public List<PDOutputIntent> getOutputIntents() {
        COSObject base = this.getKey(ASAtom.OUTPUT_INTENTS);
        if (base != null && base.getType() == COSObjType.COS_ARRAY) {
            COSArray array = (COSArray)base.getDirectBase();
            ArrayList<PDOutputIntent> result = new ArrayList<PDOutputIntent>(array.size());
            for (COSObject obj : array) {
                if (obj == null || !obj.getType().isDictionaryBased()) continue;
                result.add(new PDOutputIntent(obj));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }

    public double[] getCropBox() {
        COSArray array = this.getInheritedCOSBBox(ASAtom.CROP_BOX);
        if (array != null) {
            return this.clipToMediaBox(PDPage.getDoubleArrayForBox(array));
        }
        return this.getMediaBox();
    }

    public double[] getBleedBox() {
        COSArray array = this.getCOSBBox(ASAtom.BLEED_BOX);
        if (array != null) {
            return this.clipToMediaBox(PDPage.getDoubleArrayForBox(array));
        }
        return this.getCropBox();
    }

    public double[] getTrimBox() {
        COSArray array = this.getCOSBBox(ASAtom.TRIM_BOX);
        if (array != null) {
            return this.clipToMediaBox(PDPage.getDoubleArrayForBox(array));
        }
        return this.getCropBox();
    }

    public double[] getArtBox() {
        COSArray array = this.getCOSBBox(ASAtom.ART_BOX);
        if (array != null) {
            return this.clipToMediaBox(PDPage.getDoubleArrayForBox(array));
        }
        return this.getCropBox();
    }

    private double[] clipToMediaBox(double[] box) {
        double[] res = new double[4];
        double[] mediaBox = this.getMediaBox();
        res[0] = Math.max(box[0], mediaBox[0]);
        res[1] = Math.max(box[1], mediaBox[1]);
        res[2] = Math.min(box[2], mediaBox[2]);
        res[3] = Math.min(box[3], mediaBox[3]);
        return res;
    }

    private static double[] getDoubleArrayForBox(COSArray array) {
        if (array == null) {
            return null;
        }
        double[] res = new double[4];
        for (int i = 0; i < array.size(); ++i) {
            COSObject obj = array.at(i);
            res[i] = obj.getType().isNumber() ? obj.getReal() : 0.0;
        }
        return res;
    }

    public PDDocument getPDDocument() {
        COSDocument cosDocument = super.getObject().getDocument();
        if (cosDocument != null) {
            return cosDocument.getPDDocument();
        }
        return null;
    }

    public PDResources getResources() {
        if (this.resources != null) {
            return this.resources;
        }
        COSObject resources = this.getInheritableResources();
        if (resources != null) {
            this.resources = new PDResources(resources);
        } else {
            LOGGER.log(Level.WARNING, "Missing /Resources entry or inherited resources in the page dictionary");
        }
        return this.resources;
    }

    public Boolean isInheritedResources() {
        return this.getObject().knownKey(ASAtom.RESOURCES) == false;
    }

    public void setResources(PDResources resources) {
        this.resources = resources;
        if (resources != null) {
            this.getObject().setKey(ASAtom.RESOURCES, resources.getObject());
        } else {
            this.getObject().removeKey(ASAtom.RESOURCES);
        }
    }

    public PDContentStream getContent() {
        return this.content;
    }

    public void setContent(PDContentStream content) {
        this.content = content;
    }

    public PDGroup getGroup() {
        COSObject group = this.getKey(ASAtom.GROUP);
        if (group != null && group.getType() == COSObjType.COS_DICT) {
            return new PDGroup(group);
        }
        return null;
    }

    public PDColorSpace getGroupCS() {
        PDGroup group = this.getGroup();
        if (group != null) {
            return group.getColorSpace();
        }
        return null;
    }

    public COSArray getCOSMediaBox() {
        return this.getInheritedCOSBBox(ASAtom.MEDIA_BOX);
    }

    public COSArray getCOSCropBox() {
        return this.getInheritedCOSBBox(ASAtom.CROP_BOX);
    }

    public COSArray getCOSBleedBox() {
        return this.getCOSBBox(ASAtom.BLEED_BOX);
    }

    public COSArray getCOSTrimBox() {
        return this.getCOSBBox(ASAtom.TRIM_BOX);
    }

    public COSArray getCOSArtBox() {
        return this.getCOSBBox(ASAtom.ART_BOX);
    }

    private COSArray getCOSBBox(ASAtom type) {
        COSObject object = this.getKey(type);
        if (object != null && object.getType() == COSObjType.COS_ARRAY) {
            return (COSArray)object.getDirectBase();
        }
        return null;
    }

    private COSArray getInheritedCOSBBox(ASAtom type) {
        for (COSObject current = this.getObject(); current != null && current.getType().isDictionaryBased(); current = current.getKey(ASAtom.PARENT)) {
            COSObject object = current.getKey(type);
            if (object == null || object.empty()) continue;
            if (object.getType() == COSObjType.COS_ARRAY) {
                return (COSArray)object.getDirectBase();
            }
            return null;
        }
        return null;
    }

    public COSObject getCOSPresSteps() {
        COSObject pres = this.getKey(ASAtom.PRES_STEPS);
        return pres == null || pres.empty() || pres.getType() == COSObjType.COS_NULL ? null : pres;
    }

    public List<PDAnnotation> getAnnotations() {
        COSObject annots = this.getKey(ASAtom.ANNOTS);
        if (!annots.empty() && annots.getType() == COSObjType.COS_ARRAY) {
            ArrayList<PDAnnotation> res = new ArrayList<PDAnnotation>();
            if (annots.isIndirect().booleanValue()) {
                annots = annots.getDirect();
            }
            for (COSObject annot : (COSArray)annots.getDirectBase()) {
                if (annot == null || annot.getType() != COSObjType.COS_DICT) continue;
                if (ASAtom.WIDGET.equals(annot.getNameKey(ASAtom.SUBTYPE))) {
                    res.add(new PDWidgetAnnotation(annot));
                    continue;
                }
                res.add(new PDAnnotation(annot));
            }
            return Collections.unmodifiableList(res);
        }
        if (annots.empty()) {
            annots = COSArray.construct();
            this.setKey(ASAtom.ANNOTS, annots);
        }
        return Collections.emptyList();
    }

    public PDPageAdditionalActions getAdditionalActions() {
        COSObject aaDict = this.getKey(ASAtom.AA);
        if (aaDict != null && aaDict.getType() == COSObjType.COS_DICT) {
            return new PDPageAdditionalActions(aaDict);
        }
        return null;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public Long getRotation() {
        for (COSObject current = this.getObject(); current != null && current.getType().isDictionaryBased(); current = current.getKey(ASAtom.PARENT)) {
            COSObject object = current.getKey(ASAtom.ROTATE);
            if (object == null || object.empty()) continue;
            if (object.getType() == COSObjType.COS_INTEGER) {
                return object.getInteger();
            }
            return 0L;
        }
        return 0L;
    }

    public Double getScaling() {
        return this.getObject().getRealKey(ASAtom.PZ);
    }

    public PDMetadata getMetadata() {
        COSObject obj = this.getKey(ASAtom.METADATA);
        if (obj.getType() == COSObjType.COS_STREAM) {
            return new PDMetadata(obj);
        }
        return null;
    }

    public PDNavigationNode getPresSteps() {
        COSObject cosPresSteps = this.getCOSPresSteps();
        if (cosPresSteps != null) {
            return new PDNavigationNode(cosPresSteps);
        }
        return null;
    }

    public String getTabs() {
        COSObject tabs = this.getKey(ASAtom.TABS);
        if (tabs == null || tabs.empty()) {
            return null;
        }
        if (tabs.getType() != COSObjType.COS_NAME) {
            LOGGER.log(Level.WARNING, "Entry Tabs in page dictionary " + this.getObject().getKey() + " does not have type name");
            return null;
        }
        return tabs.getString();
    }
}

