/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.opentype;

import java.io.IOException;
import java.util.List;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.cos.COSObject;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cff.CFFFontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.truetype.TrueTypeFontProgram;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.resource.ASFileStreamCloser;

public class OpenTypeFontProgram
implements FontProgram {
    private static final long CFF = 1128678944L;
    private boolean isCFF;
    private boolean isSymbolic;
    private boolean isSubset;
    private COSObject encoding;
    private ASInputStream source;
    private FontProgram font;
    private int numTables;
    private boolean attemptedParsing = false;
    private boolean successfullyParsed = false;
    private CMap externalCMap;

    public OpenTypeFontProgram(ASInputStream source, boolean isCFF, boolean isSymbolic, COSObject encoding, CMap externalCMap, boolean isSubset) {
        this.source = source;
        this.isCFF = isCFF;
        this.isSymbolic = isSymbolic;
        this.encoding = encoding;
        this.externalCMap = externalCMap;
        this.isSubset = isSubset;
    }

    @Override
    public float getWidth(int code) {
        return this.font.getWidth(code);
    }

    @Override
    public float getWidth(String glyphName) {
        return this.font.getWidth(glyphName);
    }

    @Override
    public boolean containsCode(int code) {
        return this.font.containsCode(code);
    }

    @Override
    public boolean containsGlyph(String glyphName) {
        return this.font.containsGlyph(glyphName);
    }

    @Override
    public boolean containsCID(int cid) {
        return this.font.containsCID(cid);
    }

    @Override
    public String getGlyphName(int code) {
        return this.font.getGlyphName(code);
    }

    @Override
    public boolean isAttemptedParsing() {
        return this.attemptedParsing;
    }

    @Override
    public boolean isSuccessfulParsing() {
        return this.successfullyParsed;
    }

    @Override
    public void parseFont() throws IOException {
        if (!this.attemptedParsing) {
            this.attemptedParsing = true;
            if (!this.isCFF) {
                this.font = new TrueTypeFontProgram(this.source, this.isSymbolic, this.encoding);
                this.font.parseFont();
            } else {
                try (ASInputStream cffTable = this.getCFFTable();){
                    this.font = new CFFFontProgram(cffTable, this.externalCMap, this.isSubset);
                    this.font.parseFont();
                }
            }
            StaticResources.cacheFontProgram(null, this.font);
            this.successfullyParsed = true;
        }
    }

    public FontProgram getFont() {
        return this.font;
    }

    private ASInputStream getCFFTable() throws IOException {
        try (SeekableInputStream is = SeekableInputStream.getSeekableStream(this.source);){
            this.readHeader(is);
            for (int i = 0; i < this.numTables; ++i) {
                long tabName = this.readULong(is);
                this.readULong(is);
                long offset = this.readULong(is);
                long length = this.readULong(is);
                if (tabName != 1128678944L) continue;
                ASInputStream aSInputStream = is.getStream(offset, length);
                return aSInputStream;
            }
        }
        throw new IOException("Can't locate \"CFF \" table in CFF OpenType font program.");
    }

    private void readHeader(ASInputStream is) throws IOException {
        is.skip(4);
        this.numTables = this.readUShort(is);
        is.skip(6);
    }

    private int readUShort(ASInputStream is) throws IOException {
        int highOrder = (is.read() & 0xFF) << 8;
        return highOrder | is.read() & 0xFF;
    }

    private long readULong(ASInputStream is) throws IOException {
        long res = this.readUShort(is);
        return (res <<= 16) | (long)this.readUShort(is);
    }

    @Override
    public ASFileStreamCloser getFontProgramResource() {
        if (this.source instanceof ASMemoryInStream) {
            return null;
        }
        return new ASFileStreamCloser(this.source);
    }

    @Override
    public String getWeight() {
        return null;
    }

    @Override
    public Double getAscent() {
        return null;
    }

    @Override
    public Double getDescent() {
        return null;
    }

    @Override
    public List<Integer> getCIDList() {
        return this.font.getCIDList();
    }
}

