/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.truetype;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.font.CIDToGIDMapping;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.cmap.CMap;
import org.verapdf.pd.font.truetype.BaseTrueTypeProgram;
import org.verapdf.pd.font.truetype.TrueTypeMaxpTable;

public class CIDFontType2Program
extends BaseTrueTypeProgram
implements FontProgram {
    private CMap cMap;
    private CIDToGIDMapping cidToGID;

    public CIDFontType2Program(ASInputStream stream, CMap cMap, COSObject cidToGID) throws IOException {
        super(stream);
        this.cMap = cMap;
        this.cidToGID = new CIDToGIDMapping(cidToGID);
    }

    @Override
    public float getWidth(int code) {
        int cid = this.cMap.toCID(code);
        return this.getWidthWithCheck(this.cidToGID.getGID(cid));
    }

    @Override
    public float getWidth(String glyphName) {
        return 0.0f;
    }

    @Override
    public boolean containsCode(int code) {
        if (this.cMap.containsCode(code)) {
            int cid = this.cMap.toCID(code);
            return this.containsCID(cid);
        }
        return false;
    }

    @Override
    public boolean containsGlyph(String glyphName) {
        return false;
    }

    @Override
    public String getGlyphName(int code) {
        return null;
    }

    @Override
    public boolean containsCID(int cid) {
        if (this.cidToGID.contains(cid) && cid != 0) {
            int gid = this.cidToGID.getGID(cid);
            TrueTypeMaxpTable maxpParser = this.parser.getMaxpParser();
            return maxpParser != null && gid < maxpParser.getNumGlyphs();
        }
        return false;
    }

    @Override
    public List<Integer> getCIDList() {
        if (!this.cidToGID.isIdentity()) {
            int size = this.cidToGID.getMappingSize();
            ArrayList<Integer> res = new ArrayList<Integer>(size);
            for (int i = 0; i < size; ++i) {
                if (!this.containsCID(i)) continue;
                res.add(i);
            }
            return res;
        }
        int size = this.widths.length;
        ArrayList<Integer> res = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            res.add(i);
        }
        return res;
    }
}

