/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.parser;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.CharTable;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.as.io.ASMemoryInStream;
import org.verapdf.cos.COSBoolean;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSInteger;
import org.verapdf.cos.COSNull;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSReal;
import org.verapdf.cos.COSString;
import org.verapdf.exceptions.VeraPDFParserException;
import org.verapdf.operator.InlineImageOperator;
import org.verapdf.operator.Operator;
import org.verapdf.parser.NotSeekableCOSParser;
import org.verapdf.parser.Operators;
import org.verapdf.parser.Token;
import org.verapdf.pd.images.PDInlineImage;

public class PDFStreamParser
extends NotSeekableCOSParser {
    private static final Logger LOGGER = Logger.getLogger(PDFStreamParser.class.getCanonicalName());
    private static final int INLINE_IMAGE_BUFFER_SIZE = 8192;
    private final List<Object> tokens = new ArrayList<Object>();
    private final List<Closeable> imageDataStreams = new ArrayList<Closeable>();
    private COSDictionary lastInlineImageDict;

    public PDFStreamParser(ASInputStream stream) throws IOException {
        super(stream);
        this.getBaseParser().initializeToken();
    }

    public void parseTokens() throws IOException {
        Object token = this.parseNextToken();
        while (token != null) {
            if (token instanceof COSObject) {
                token = ((COSObject)token).get();
            }
            this.tokens.add(token);
            token = this.parseNextToken();
        }
    }

    public List<Object> getTokens() {
        return this.tokens;
    }

    public Iterator<Object> getTokensIterator() {
        return new TokensIterator();
    }

    public Object parseNextToken() throws IOException {
        this.getBaseParser().skipSpaces(true);
        int nextByte = this.getSource().peek();
        if (nextByte == -1) {
            return null;
        }
        int c = nextByte;
        Object result = null;
        switch (c) {
            case 40: {
                this.getBaseParser().nextToken();
                result = COSString.construct(this.getBaseParser().getToken().getByteValue());
                break;
            }
            case 60: {
                this.getSource().readByte();
                c = this.getSource().peek();
                this.getSource().unread();
                if (c == 60) {
                    result = this.getDictionary();
                    break;
                }
                this.getBaseParser().nextToken();
                Token token = this.getBaseParser().getToken();
                result = COSString.construct(token.getByteValue(), true, token.getHexCount(), token.isContainsOnlyHex());
                break;
            }
            case 91: {
                result = this.getArray();
                break;
            }
            case 47: {
                result = this.getName();
                break;
            }
            case 110: {
                String nullString = this.getBaseParser().readUntilDelimiter();
                if ("null".equals(nullString)) {
                    result = new COSObject(COSNull.NULL);
                    break;
                }
                result = Operator.getOperator(nullString);
                break;
            }
            case 102: 
            case 116: {
                String line = this.getBaseParser().readUntilDelimiter();
                if ("true".equals(line)) {
                    result = new COSObject(COSBoolean.TRUE);
                    break;
                }
                if ("false".equals(line)) {
                    result = new COSObject(COSBoolean.FALSE);
                    break;
                }
                result = Operator.getOperator(line);
                break;
            }
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                Token token = this.getBaseParser().getToken();
                this.getBaseParser().nextToken();
                if (token.type == Token.Type.TT_REAL) {
                    result = COSReal.construct(token.real);
                    break;
                }
                if (token.type != Token.Type.TT_INTEGER) break;
                result = COSInteger.construct(token.integer);
                break;
            }
            case 66: {
                COSDictionary imageParameters;
                Token token = this.getBaseParser().getToken();
                this.getBaseParser().nextToken();
                result = Operator.getOperator(token.getValue());
                if (!(result instanceof InlineImageOperator)) break;
                InlineImageOperator imageOperator = (InlineImageOperator)result;
                this.lastInlineImageDict = imageParameters = (COSDictionary)COSDictionary.construct().get();
                imageOperator.setImageParameters(imageParameters);
                Object nextToken = this.parseNextToken();
                while (nextToken instanceof COSObject && ((COSObject)nextToken).getType() == COSObjType.COS_NAME) {
                    Object value = this.parseNextToken();
                    if (value instanceof COSObject) {
                        imageParameters.setKey(((COSObject)nextToken).getName(), (COSObject)value);
                    } else {
                        LOGGER.log(Level.FINE, "Unexpected token in BI operator parsing: " + value.toString());
                    }
                    nextToken = this.parseNextToken();
                }
                if (nextToken instanceof InlineImageOperator) {
                    imageOperator.setImageData(((InlineImageOperator)nextToken).getImageData());
                    break;
                }
                throw new IOException("Unexpected token instead of operator in operator parsing: " + nextToken.toString());
            }
            case 73: {
                if (this.getSource().readByte() != 73 || this.getSource().readByte() != 68) {
                    throw new IOException("Corrupted inline image operator");
                }
                if (CharTable.isSpace(this.getSource().peek())) {
                    this.getSource().readByte();
                }
                ASInputStream imageDataStream = this.readInlineImage();
                result = Operator.getOperator("ID");
                this.imageDataStreams.add(imageDataStream);
                ((InlineImageOperator)result).setImageData(imageDataStream);
                break;
            }
            default: {
                String operator = this.nextOperator();
                result = operator.isEmpty() ? null : Operator.getOperator(operator);
            }
        }
        return result;
    }

    protected String nextOperator() throws IOException {
        this.getBaseParser().skipSpaces();
        StringBuilder buffer = new StringBuilder(5);
        int nextByte = this.getSource().peek();
        while (!(this.getSource().isEOF() || CharTable.isSpace(nextByte) || nextByte == 93 || nextByte == 91 || nextByte == 60 || nextByte == 40 || nextByte == 47 || nextByte >= 48 && nextByte <= 57)) {
            byte currentByte = this.getSource().readByte();
            buffer.append((char)currentByte);
            if (this.getSource().isEOF()) continue;
            nextByte = this.getSource().peek();
            if (currentByte != 100 || nextByte != 48 && nextByte != 49) continue;
            buffer.append((char)this.getSource().readByte());
            nextByte = this.getSource().peek();
        }
        return buffer.toString();
    }

    private ASInputStream readInlineImage() throws IOException {
        this.getSource().resetReadCounter();
        Long l = this.lastInlineImageDict == null ? Long.valueOf(0L) : PDInlineImage.getInlineImageKey(this.lastInlineImageDict, ASAtom.LENGTH).getInteger();
        ArrayList<Byte> image = new ArrayList<Byte>(8192);
        byte previousByte = this.getSource().readByte();
        byte currentByte = this.getSource().readByte();
        boolean imageEndFound = false;
        while (!this.getSource().isEOF()) {
            if (previousByte == 69 && currentByte == 73 && this.isSourceAfterImage(l) && CharTable.isSpace(this.getSource().peek())) {
                if (this.checkInlineImage()) {
                    imageEndFound = true;
                    break;
                }
                LOGGER.log(Level.WARNING, "Inline image content contains EI inside");
            }
            image.add(previousByte);
            previousByte = currentByte;
            currentByte = this.getSource().readByte();
        }
        if (previousByte == 69 && currentByte == 73) {
            imageEndFound = true;
        }
        if (!imageEndFound) {
            LOGGER.log(Level.WARNING, "End of inline image not found");
        }
        return new ASMemoryInStream(PDFStreamParser.getByteArrayFromArrayList(image), this.getSource().getReadCounter(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkInlineImage() throws IOException {
        int readCounter = this.getSource().getReadCounter();
        try {
            Object token = this.parseNextToken();
            if (token instanceof Operator && !Operators.operators.contains(((Operator)token).getOperator())) {
                boolean bl = false;
                return bl;
            }
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.getSource().unread(this.getSource().getReadCounter() - readCounter);
        }
        return true;
    }

    private boolean isSourceAfterImage(Long length) {
        return length == null || (long)this.getSource().getReadCounter() >= length;
    }

    public List<Closeable> getImageDataStreams() {
        return this.imageDataStreams;
    }

    public static byte[] getByteArrayFromArrayList(List<Byte> list) {
        byte[] res = new byte[list.size()];
        int i = 0;
        for (Byte b : list) {
            res[i++] = b;
        }
        return res;
    }

    private class TokensIterator
    implements Iterator<Object> {
        private Object token;

        private TokensIterator() {
        }

        private void tryNext() {
            try {
                if (this.token == null) {
                    this.token = PDFStreamParser.this.parseNextToken();
                }
            }
            catch (IOException e) {
                throw new VeraPDFParserException(e);
            }
        }

        @Override
        public boolean hasNext() {
            this.tryNext();
            return this.token != null;
        }

        @Override
        public Object next() {
            this.tryNext();
            Object tmp = this.token;
            if (tmp == null) {
                throw new NoSuchElementException();
            }
            this.token = null;
            return tmp;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

