/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.as.io.ASInputStream;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;

public class CIDToGIDMapping {
    private static final Logger LOGGER = Logger.getLogger(CIDToGIDMapping.class.getCanonicalName());
    private int[] mapping;
    private final boolean isIdentity;

    public CIDToGIDMapping(COSObject obj) throws IOException {
        if (obj != null && (obj.getType() == COSObjType.COS_STREAM || obj.getType() == COSObjType.COS_NAME && obj.getName() == ASAtom.IDENTITY)) {
            if (obj.getType() == COSObjType.COS_NAME && obj.getName() == ASAtom.IDENTITY) {
                this.isIdentity = true;
                this.mapping = new int[0];
                return;
            }
            this.isIdentity = false;
            try (ASInputStream stream = obj.getData(COSStream.FilterFlags.DECODE);){
                this.parseCIDToGIDStream(stream);
            }
            return;
        }
        this.isIdentity = true;
        this.mapping = new int[0];
    }

    public int getGID(int cid) {
        if (this.isIdentity) {
            return cid;
        }
        if (cid < this.mapping.length) {
            return this.mapping[cid];
        }
        return 0;
    }

    public boolean contains(int cid) {
        if (this.isIdentity) {
            return true;
        }
        return cid < this.mapping.length && cid >= 0;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public int getMappingSize() {
        return this.mapping.length;
    }

    private void parseCIDToGIDStream(ASInputStream stream) throws IOException {
        List<Integer> mappingList = CIDToGIDMapping.readMapping(stream);
        this.mapping = new int[mappingList.size()];
        for (int i = 0; i < mappingList.size(); ++i) {
            this.mapping[i] = mappingList.get(i);
        }
    }

    private static List<Integer> readMapping(ASInputStream stream) throws IOException {
        ArrayList<Integer> res = new ArrayList<Integer>();
        int b = stream.read();
        while (b != -1) {
            int num = b;
            num <<= 8;
            b = stream.read();
            if (b != -1) {
                res.add(num += b);
                b = stream.read();
                continue;
            }
            res.add(num);
        }
        return res;
    }
}

