/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.cff;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.io.SeekableInputStream;
import org.verapdf.pd.font.cff.CFFIndex;

class CFFCharStringsHandler {
    private static final Logger LOGGER = Logger.getLogger(CFFCharStringsHandler.class.getCanonicalName());
    private static final int MAX_BUFFER_SIZE = 10240;
    private final int amount;
    private CFFIndex memoryInCharStirngs;
    private SeekableInputStream fontStream;
    private long[] charStringsOffsets;

    CFFCharStringsHandler(CFFIndex charStrings, long charStringsOffset, SeekableInputStream fontStream) {
        this.amount = charStrings.size();
        if (charStrings.getDataLength() < 10240) {
            this.memoryInCharStirngs = charStrings;
        } else {
            this.fontStream = fontStream;
            this.charStringsOffsets = new long[charStrings.size() + 1];
            for (int i = 0; i < charStrings.size() + 1; ++i) {
                this.charStringsOffsets[i] = charStringsOffset + (long)charStrings.getOffsetShift() + (long)charStrings.getOffset(i) - 1L;
            }
        }
    }

    byte[] getCharString(int num) throws IOException {
        if (num >= 0 && num < this.amount) {
            if (this.memoryInCharStirngs != null) {
                return this.memoryInCharStirngs.get(num);
            }
            long offset = this.fontStream.getOffset();
            this.fontStream.seek(this.charStringsOffsets[num]);
            byte[] res = new byte[(int)(this.charStringsOffsets[num + 1] - this.charStringsOffsets[num])];
            this.fontStream.read(res, res.length);
            this.fontStream.seek(offset);
            return res;
        }
        LOGGER.log(Level.FINE, "Cannot obtain charstring " + num + ", total " + this.amount + " charstrings ");
        return new byte[0];
    }

    int getCharStringAmount() {
        return this.amount;
    }
}

