/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.font.type3;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.cos.COSStream;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.font.FontProgram;
import org.verapdf.pd.font.PDSimpleFont;
import org.verapdf.pd.font.type3.Type3CharProcParser;
import org.verapdf.tools.TypeConverter;

public class PDType3Font
extends PDSimpleFont {
    private static final Logger LOGGER = Logger.getLogger(PDType3Font.class.getCanonicalName());

    public PDType3Font(COSDictionary dictionary) {
        super(dictionary);
        this.setSuccessfullyParsed(true);
        this.boundingBox = this.getFontBoundingBox();
        if (this.boundingBox == null) {
            this.boundingBox = new double[]{0.0, 0.0, 1000.0, 1000.0};
        }
    }

    public COSDictionary getCharProcDict() {
        return (COSDictionary)this.dictionary.getKey(ASAtom.CHAR_PROCS).getDirectBase();
    }

    @Override
    public FontProgram getFontProgram() {
        return null;
    }

    public PDResources getResources() {
        COSObject resources = this.dictionary.getKey(ASAtom.RESOURCES);
        if (!resources.empty() && resources.getType() == COSObjType.COS_DICT) {
            if (resources.isIndirect().booleanValue()) {
                resources = resources.getDirect();
            }
            return new PDResources(resources);
        }
        return new PDResources(COSDictionary.construct());
    }

    @Override
    public String getName() {
        return this.dictionary.getNameKeyStringValue(ASAtom.NAME);
    }

    public boolean containsCharString(int code) {
        return !this.getCharProc(code).empty();
    }

    public double[] getFontBoundingBox() {
        COSObject bbox = this.getKey(ASAtom.FONT_BBOX);
        if (bbox.getType() == COSObjType.COS_ARRAY && bbox.size() == 4) {
            double[] res = new double[4];
            for (int i = 0; i < 4; ++i) {
                COSObject obj = bbox.at(i);
                if (!obj.getType().isNumber()) {
                    String fontName = this.getName() == null ? "" : this.getName();
                    LOGGER.log(Level.SEVERE, "Font bounding box array for font " + fontName + " contains " + (Object)((Object)obj.getType()));
                    return null;
                }
                res[i] = obj.getReal();
            }
            return res;
        }
        String fontName = this.getName() == null ? "" : this.getName();
        LOGGER.log(Level.SEVERE, "Font bounding box array for font " + fontName + " is not an array of 4 elements");
        return null;
    }

    public double[] getFontMatrix() {
        return TypeConverter.getRealArray(this.getKey(ASAtom.FONT_MATRIX), 6, "Font matrix");
    }

    private COSDictionary getCharProcs() {
        return (COSDictionary)this.dictionary.getKey(ASAtom.CHAR_PROCS).getDirectBase();
    }

    private COSObject getCharProc(int code) {
        String glyphName = this.getEncodingMapping().getName(code);
        COSDictionary charProcs = this.getCharProcs();
        if (charProcs != null) {
            ASAtom asAtomGlyph = ASAtom.getASAtom(glyphName);
            return charProcs.getKey(asAtomGlyph);
        }
        return COSObject.getEmpty();
    }

    @Override
    public float getWidthFromProgram(int code) {
        COSObject charProc = this.getCharProc(code);
        if (charProc.getType() == COSObjType.COS_STREAM) {
            float f;
            Type3CharProcParser parser = new Type3CharProcParser(charProc.getData(COSStream.FilterFlags.DECODE));
            try {
                parser.parse();
                f = (float)parser.getWidth();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        parser.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, "Can't get width from type 3 char proc", e);
                }
            }
            parser.close();
            return f;
        }
        return -1.0f;
    }

    @Override
    public boolean glyphIsPresent(int code) {
        return this.containsCharString(code);
    }
}

