/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.structure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.exceptions.LoopedException;
import org.verapdf.pd.PDObject;

public class PDNumberTreeNode
extends PDObject
implements Iterable<COSObject> {
    private final Set<COSKey> parents;
    private long[] limitsArray = null;
    private List<PDNumberTreeNode> kids = null;
    private Map<Long, COSObject> nums = null;

    public PDNumberTreeNode(COSObject obj) {
        this(obj, new HashSet<COSKey>());
    }

    private PDNumberTreeNode(COSObject obj, Set<COSKey> parents) {
        super(obj);
        COSKey objectKey = obj.getObjectKey();
        this.parents = new HashSet<COSKey>(parents);
        if (objectKey != null) {
            if (parents.contains(objectKey)) {
                throw new LoopedException("Loop inside number tree");
            }
            this.parents.add(objectKey);
        }
    }

    public long[] getLimitsArray() {
        if (this.limitsArray == null) {
            this.limitsArray = this.parseLimitsArray();
        }
        return this.limitsArray;
    }

    public long[] parseLimitsArray() {
        COSObject limits = this.getKey(ASAtom.LIMITS);
        if (limits != null && !limits.empty() && limits.getType() == COSObjType.COS_ARRAY && limits.size() >= 2 && limits.at(0).getType() == COSObjType.COS_INTEGER && limits.at(1).getType() == COSObjType.COS_INTEGER) {
            long[] res = new long[]{limits.at(0).getInteger(), limits.at(1).getInteger()};
            return res;
        }
        return new long[0];
    }

    public List<PDNumberTreeNode> getKids() {
        if (this.kids == null) {
            this.kids = this.parseKids();
        }
        return Collections.unmodifiableList(this.kids);
    }

    public List<PDNumberTreeNode> parseKids() {
        COSObject kids = this.getKey(ASAtom.KIDS);
        if (kids != null && !kids.empty() && kids.getType() == COSObjType.COS_ARRAY) {
            ArrayList<PDNumberTreeNode> res = new ArrayList<PDNumberTreeNode>(kids.size());
            for (COSObject obj : (COSArray)kids.getDirectBase()) {
                res.add(new PDNumberTreeNode(obj, this.parents));
            }
            return Collections.unmodifiableList(res);
        }
        return Collections.emptyList();
    }

    public Map<Long, COSObject> parseNums() {
        COSObject nums = this.getKey(ASAtom.NUMS);
        if (nums != null && !nums.empty() && nums.getType() == COSObjType.COS_ARRAY) {
            HashMap<Long, COSObject> res = new HashMap<Long, COSObject>();
            for (int i = 0; i < nums.size() - 1; i += 2) {
                COSObject key = nums.at(i);
                if (key.getType() != COSObjType.COS_INTEGER) continue;
                COSObject value = nums.at(i + 1);
                res.put(key.getInteger(), value);
            }
            return Collections.unmodifiableMap(res);
        }
        return Collections.emptyMap();
    }

    public Map<Long, COSObject> getNums() {
        if (this.nums == null) {
            this.nums = this.parseNums();
        }
        return Collections.unmodifiableMap(this.nums);
    }

    private List<COSObject> getObjects() {
        LinkedList<COSObject> result = new LinkedList<COSObject>(this.getNums().values());
        for (PDNumberTreeNode kid : this.getKids()) {
            result.addAll(kid.getObjects());
        }
        return result;
    }

    public COSObject getObject(Long key) {
        HashSet<COSKey> visitedKeys = new HashSet<COSKey>();
        COSKey objectKey = this.getObject().getObjectKey();
        if (objectKey != null) {
            visitedKeys.add(objectKey);
        }
        return this.getObject(key, visitedKeys);
    }

    private COSObject getObject(Long key, Set<COSKey> visitedKeys) {
        List<PDNumberTreeNode> kids;
        long[] limits = this.getLimitsArray();
        if (limits.length == 2 && (key < limits[0] || key > limits[1])) {
            return null;
        }
        if (this.knownKey(ASAtom.NUMS)) {
            Map<Long, COSObject> nums = this.getNums();
            return nums == null ? null : nums.get(key);
        }
        if (this.knownKey(ASAtom.KIDS) && (kids = this.getKids()) != null) {
            for (PDNumberTreeNode kid : kids) {
                COSObject res = kid.getObject(key, visitedKeys);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    @Override
    public Iterator<COSObject> iterator() {
        return this.getObjects().iterator();
    }

    public Long size() {
        long i = 0L;
        Iterator<COSObject> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++i;
        }
        return i;
    }

    public boolean containsKey(Long key) {
        return this.getObject(key) != null;
    }

    public boolean containsValue(COSObject value) {
        for (COSObject object : this) {
            if (object == null || !object.equals(value)) continue;
            return true;
        }
        return false;
    }
}

