/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.external;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**  JPEG2000 image
 */
public interface JPEG2000 extends External {
	

	/**  the number of colour channels
	 */
	public Long getnrColorChannels();

	/**  the number of colour space specifications
	 */
	public Long getnrColorSpaceSpecs();

	/**  the number of colour space specifications with APPROX field set to 0x01
	 */
	public Long getnrColorSpacesWithApproxField();

	/**  the METH entry in the 'colr' box specification with APPROX field equal to 0x01
	 */
	public Long getcolrMethod();

	/**  EnumCS (enumerated color space) field of in the 'colr' box specification with APPROX field equal to 0x01
	 */
	public Long getcolrEnumCS();

	/**  image bit depth
	 */
	public Long getbitDepth();

	/**  true if the 'bpcc' box is present and, thus, the bit depth is not constant across all components
	 */
	public Boolean getbpccBoxPresent();
}
