/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.features.pb.objects;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.verapdf.features.objects.AnnotationFeaturesObjectAdapter;
import org.verapdf.features.pb.tools.PBAdapterHelper;

public class PBAnnotationFeaturesObjectAdapter
implements AnnotationFeaturesObjectAdapter {
    private static final int LOCKED_CONTENTS_FLAG = 512;
    private PDAnnotation annot;
    private String id;
    private String popupId;
    private Set<String> formXObjects;

    public PBAnnotationFeaturesObjectAdapter(PDAnnotation annot, String id, String popupId, Set<String> formXObjects) {
        this.annot = annot;
        this.id = id;
        this.popupId = popupId;
        this.formXObjects = formXObjects;
    }

    public String getId() {
        return this.id;
    }

    public String getPopupId() {
        return this.popupId;
    }

    public Set<String> getFormXObjectsResources() {
        return this.formXObjects == null ? Collections.emptySet() : Collections.unmodifiableSet(this.formXObjects);
    }

    public String getSubtype() {
        if (this.annot != null) {
            return this.annot.getSubtype();
        }
        return null;
    }

    public double[] getRectangle() {
        if (this.annot != null) {
            return PBAdapterHelper.parseRectangle(this.annot.getRectangle());
        }
        return null;
    }

    public String getContents() {
        if (this.annot != null) {
            return this.annot.getContents();
        }
        return null;
    }

    public String getAnnotationName() {
        if (this.annot != null) {
            return this.annot.getAnnotationName();
        }
        return null;
    }

    public String getModifiedDate() {
        if (this.annot != null) {
            return this.annot.getModifiedDate();
        }
        return null;
    }

    public double[] getColor() {
        PDColor color;
        if (this.annot != null && (color = this.annot.getColor()) != null) {
            return PBAdapterHelper.castFloatArrayToDouble(color.getComponents());
        }
        return null;
    }

    public boolean isInvisible() {
        return this.annot != null && this.annot.isInvisible();
    }

    public boolean isHidden() {
        return this.annot != null && this.annot.isHidden();
    }

    public boolean isPrinted() {
        return this.annot != null && this.annot.isPrinted();
    }

    public boolean isNoZoom() {
        return this.annot != null && this.annot.isNoZoom();
    }

    public boolean isNoRotate() {
        return this.annot != null && this.annot.isNoRotate();
    }

    public boolean isNoView() {
        return this.annot != null && this.annot.isNoView();
    }

    public boolean isReadOnly() {
        return this.annot != null && this.annot.isReadOnly();
    }

    public boolean isLocked() {
        return this.annot != null && this.annot.isLocked();
    }

    public boolean isToggleNoView() {
        return this.annot != null && this.annot.isToggleNoView();
    }

    public boolean isLockedContents() {
        if (this.annot != null) {
            return (this.annot.getAnnotationFlags() & 0x200) == 512;
        }
        return false;
    }

    public boolean isPDFObjectPresent() {
        return this.annot != null;
    }

    public List<String> getErrors() {
        return Collections.emptyList();
    }
}

