/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.util;

import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSDictionary;
import org.verapdf.cos.COSName;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.pd.PDExtGState;
import org.verapdf.pd.PDResource;
import org.verapdf.pd.PDResources;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceCMYK;
import org.verapdf.pd.colors.PDDeviceGray;
import org.verapdf.pd.colors.PDDeviceRGB;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.images.PDXObject;
import org.verapdf.pd.patterns.PDPattern;
import org.verapdf.pd.patterns.PDShading;

public class PDResourcesHandler {
    private static final Logger LOGGER = Logger.getLogger(PDResourcesHandler.class.getCanonicalName());
    public static final PDResourcesHandler EMPTY = PDResourcesHandler.getInstance(new PDResources(COSDictionary.construct()), false);
    private final PDResources pageResources;
    private final boolean inheritedResources;
    private final PDResources objectResources;
    private Set<ASAtom> undefinedResourceNames = new HashSet<ASAtom>();
    private Set<ASAtom> inheritedResourceNames = new HashSet<ASAtom>();

    private PDResourcesHandler(PDResources pageResources, boolean inheritedResources) {
        this.pageResources = pageResources;
        this.inheritedResources = inheritedResources;
        this.objectResources = null;
    }

    private PDResourcesHandler(PDResources pageResources, PDResources objectResources) {
        this.pageResources = pageResources;
        this.inheritedResources = false;
        this.objectResources = objectResources;
    }

    public static PDResourcesHandler getInstance(PDResources resources, boolean inheritedResources) {
        return new PDResourcesHandler(resources, inheritedResources);
    }

    public static PDResourcesHandler getInstance(PDResources pageResources, PDResources objectResources) {
        return new PDResourcesHandler(pageResources, objectResources);
    }

    public PDResourcesHandler getExtendedResources(PDResources objectResources) {
        return PDResourcesHandler.getInstance(this.pageResources, objectResources);
    }

    public PDFont getFont(COSName name) {
        if (name != null) {
            return this.getFont(name.getName());
        }
        return null;
    }

    public PDFont getFont(ASAtom name) {
        PDFont font = null;
        if (this.objectResources != null) {
            font = this.objectResources.getFont(name);
            if (font == null && this.pageResources != null) {
                font = this.pageResources.getFont(name);
                this.setInherited((PDResource)font, name, true);
            }
        } else if (this.pageResources != null) {
            font = this.pageResources.getFont(name);
            this.setInherited((PDResource)font, name, this.inheritedResources);
        }
        if (font == null) {
            this.undefinedResourceNames.add(name);
            LOGGER.log(Level.SEVERE, "Undefined font " + name + " in a content stream");
        }
        return font;
    }

    public PDColorSpace getColorSpace(COSName name) {
        if (name != null) {
            return this.getColorSpace(name.getName());
        }
        return null;
    }

    public PDColorSpace getColorSpace(ASAtom name) {
        return this.getColorSpace(name, true);
    }

    public PDColorSpace getColorSpace(ASAtom name, boolean checkUndefined) {
        PDColorSpace colorSpace = null;
        if (this.objectResources != null) {
            if (this.isDefaultColorSpaceUsed(name)) {
                colorSpace = this.objectResources.getDefaultColorSpace(name);
            } else {
                colorSpace = this.objectResources.getColorSpace(name);
                if (colorSpace == null && this.pageResources != null) {
                    colorSpace = this.pageResources.getColorSpace(name);
                    colorSpace = this.setColorSpaceInherited(colorSpace, name, true);
                }
            }
        } else if (this.pageResources != null) {
            if (this.isDefaultColorSpaceUsed(name)) {
                colorSpace = this.pageResources.getDefaultColorSpace(name);
            } else {
                colorSpace = this.pageResources.getColorSpace(name);
                colorSpace = this.setColorSpaceInherited(colorSpace, name, this.inheritedResources);
            }
        }
        if (colorSpace == null && checkUndefined) {
            this.undefinedResourceNames.add(name);
            LOGGER.log(Level.SEVERE, "Undefined color space " + name + " in a content stream");
        }
        return colorSpace;
    }

    public PDPattern getPattern(COSName name) {
        if (name != null) {
            return this.getPattern(name.getName());
        }
        return null;
    }

    public PDPattern getPattern(ASAtom name) {
        PDPattern pattern = null;
        if (this.objectResources != null) {
            pattern = this.objectResources.getPattern(name);
            if (pattern == null && this.pageResources != null) {
                pattern = this.pageResources.getPattern(name);
                this.setInherited((PDResource)pattern, name, true);
            }
        } else if (this.pageResources != null) {
            pattern = this.pageResources.getPattern(name);
            this.setInherited((PDResource)pattern, name, this.inheritedResources);
        }
        if (pattern == null) {
            this.undefinedResourceNames.add(name);
            LOGGER.log(Level.SEVERE, "Undefined pattern " + name + " in a content stream");
        }
        return pattern;
    }

    public PDShading getShading(COSName name) {
        if (name != null) {
            return this.getShading(name.getName());
        }
        return null;
    }

    public PDShading getShading(ASAtom name) {
        PDShading shading = null;
        if (this.objectResources != null) {
            shading = this.objectResources.getShading(name);
            if (shading == null && this.pageResources != null) {
                shading = this.pageResources.getShading(name);
                this.setInherited((PDResource)shading, name, true);
            }
        } else if (this.pageResources != null) {
            shading = this.pageResources.getShading(name);
            this.setInherited((PDResource)shading, name, this.inheritedResources);
        }
        if (shading == null) {
            this.undefinedResourceNames.add(name);
            LOGGER.log(Level.SEVERE, "Undefined shading " + name + " in a content stream");
        }
        return shading;
    }

    public PDXObject getXObject(COSName name) {
        if (name != null) {
            return this.getXObject(name.getName());
        }
        return null;
    }

    public PDXObject getXObject(ASAtom name) {
        PDXObject xObject = null;
        if (this.objectResources != null) {
            xObject = this.objectResources.getXObject(name);
            if (xObject == null && this.pageResources != null) {
                xObject = this.pageResources.getXObject(name);
                this.setInherited((PDResource)xObject, name, true);
            }
        } else if (this.pageResources != null) {
            xObject = this.pageResources.getXObject(name);
            this.setInherited((PDResource)xObject, name, this.inheritedResources);
        }
        if (xObject == null) {
            this.undefinedResourceNames.add(name);
            LOGGER.log(Level.SEVERE, "Undefined XObject " + name + " in a content stream");
        }
        return xObject;
    }

    public PDExtGState getExtGState(COSName name) {
        if (name != null) {
            return this.getExtGState(name.getName());
        }
        return null;
    }

    public PDExtGState getExtGState(ASAtom name) {
        PDExtGState state = null;
        if (this.objectResources != null) {
            state = this.objectResources.getExtGState(name);
            if (state == null && this.pageResources != null) {
                state = this.pageResources.getExtGState(name);
                this.setInherited((PDResource)state, name, true);
            }
        } else if (this.pageResources != null) {
            state = this.pageResources.getExtGState(name);
            this.setInherited((PDResource)state, name, this.inheritedResources);
        }
        if (state == null) {
            this.undefinedResourceNames.add(name);
            LOGGER.log(Level.SEVERE, "Undefined graphics state " + name + " in a content stream");
        }
        return state;
    }

    public PDResource getProperties(COSName name) {
        if (name != null) {
            return this.getProperties(name.getName());
        }
        return null;
    }

    public PDResource getProperties(ASAtom name) {
        PDResource res = null;
        if (this.objectResources != null) {
            res = this.objectResources.getProperties(name);
            if (res == null && this.pageResources != null) {
                res = this.pageResources.getProperties(name);
                this.setInherited(res, name, true);
            }
        } else if (this.pageResources != null) {
            res = this.pageResources.getProperties(name);
            this.setInherited(res, name, this.inheritedResources);
        }
        if (res == null) {
            this.undefinedResourceNames.add(name);
            LOGGER.log(Level.SEVERE, "Undefined property " + name + " in a content stream");
        }
        return res;
    }

    public PDColorSpace setColorSpaceInherited(PDColorSpace colorSpace, ASAtom name, boolean isInherited) {
        if (isInherited) {
            if (colorSpace == PDDeviceCMYK.INSTANCE) {
                return PDDeviceCMYK.INHERITED_INSTANCE;
            }
            if (colorSpace == PDDeviceRGB.INSTANCE) {
                return PDDeviceRGB.INHERITED_INSTANCE;
            }
            if (colorSpace == PDDeviceGray.INSTANCE) {
                return PDDeviceGray.INHERITED_INSTANCE;
            }
        }
        this.setInherited((PDResource)colorSpace, name, isInherited);
        return colorSpace;
    }

    public void setInherited(PDResource resource, ASAtom name, boolean value) {
        if (resource != null) {
            resource.setInherited(value);
            if (value) {
                this.inheritedResourceNames.add(name);
            }
        }
    }

    public PDResources getObjectResources() {
        return this.objectResources;
    }

    public PDResources getPageResources() {
        return this.pageResources;
    }

    private boolean isDefaultColorSpaceUsed(ASAtom name) {
        ASAtom value;
        return PDResourcesHandler.isDeviceDependent(name) && (this.objectResources != null ? (value = ColorSpaceFactory.getDefaultValue((PDResources)this.objectResources, (ASAtom)name)) != null : (value = ColorSpaceFactory.getDefaultValue((PDResources)this.pageResources, (ASAtom)name)) != null);
    }

    private static boolean isDeviceDependent(ASAtom name) {
        return ASAtom.DEVICERGB.equals((Object)name) || ASAtom.DEVICEGRAY.equals((Object)name) || ASAtom.DEVICECMYK.equals((Object)name);
    }

    public Set<ASAtom> getUndefinedResourceNames() {
        return this.undefinedResourceNames;
    }

    public Set<ASAtom> getInheritedResourceNames() {
        return this.inheritedResourceNames;
    }
}

