/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.tools;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.factory.operators.RenderingMode;
import org.verapdf.gf.model.impl.operator.markedcontent.GFOpMarkedContent;
import org.verapdf.pd.PDOutlineItem;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDType0Font;
import org.verapdf.pd.structure.StructureElementAccessObject;

public final class GFIDGenerator {
    private GFIDGenerator() {
    }

    public static String generateID(COSKey key) {
        return String.valueOf(key.getNumber() + " " + key.getGeneration());
    }

    public static String generateID(PDFont font) {
        if (font instanceof PDType0Font) {
            return GFIDGenerator.generateID((PDType0Font)font);
        }
        int hashcode = font.getDictionary().hashCode();
        String fontName = font.getName();
        if (fontName != null && fontName.length() > 127) {
            fontName = fontName.substring(0, 127);
        }
        return String.valueOf(hashcode) + ' ' + fontName;
    }

    public static String generateID(PDType0Font font) {
        int hashcode = font.getType0FontDict().hashCode();
        String fontName = font.getName();
        if (fontName != null && fontName.length() > 127) {
            fontName = fontName.substring(0, 127);
        }
        return String.valueOf(hashcode) + ' ' + fontName;
    }

    public static String generateID(String fontID, String fontName, int glyphCode, int renderingMode, GFOpMarkedContent markedContent, StructureElementAccessObject structureElementAccessObject) {
        String markedContentID = markedContent == null ? "" : String.valueOf(markedContent.hashCode());
        String structureElementAccessID = structureElementAccessObject == null ? "" : String.valueOf(structureElementAccessObject.hashCode());
        return fontID + ' ' + fontName + ' ' + glyphCode + ' ' + renderingMode + ' ' + markedContentID + ' ' + structureElementAccessID;
    }

    public static String generateID(PDFont rawFont, RenderingMode renderingMode) {
        String fontID = GFIDGenerator.generateID(rawFont);
        return fontID + renderingMode.getValue();
    }

    public static String generateID(PDOutlineItem item) {
        COSObject dictionary = item.getObject();
        String value = GFIDGenerator.getOutlineID(dictionary, ASAtom.PREV, ASAtom.NEXT);
        return value != null ? value : GFIDGenerator.getOutlineID(dictionary, ASAtom.PARENT, ASAtom.FIRST);
    }

    private static String getOutlineID(COSObject dictionary, ASAtom kind, ASAtom key) {
        COSObject current;
        COSObject base = dictionary.getKey(kind);
        if (base != null && base.getType().isDictionaryBased() && (current = base.getKey(key)) != null && current.getKey() != null) {
            String value = GFIDGenerator.generateID(current.getKey());
            return "outline " + value;
        }
        return null;
    }

    public static String getOutlineID(PDOutlineItem item) {
        COSObject dictionary = item.getObject();
        if (dictionary != null && dictionary.getKey() != null) {
            String value = GFIDGenerator.generateID(dictionary.getKey());
            return "outline " + value;
        }
        return null;
    }
}

