/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;

public class TemporaryDirectory
implements AutoCloseable {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.getDefault());
    private static final String DEFAULT_PREFIX = "verifyica-temp-";
    private Path path;

    public TemporaryDirectory() throws IOException {
        this.initialize(DEFAULT_PREFIX, CleanupMode.ALWAYS);
    }

    public TemporaryDirectory(CleanupMode cleanupMode) throws IOException {
        if (cleanupMode == null) {
            throw new IllegalArgumentException("cleanupMode is null");
        }
        this.initialize(DEFAULT_PREFIX, cleanupMode);
    }

    public TemporaryDirectory(String prefix) throws IOException {
        this.initialize(prefix, CleanupMode.ALWAYS);
    }

    public TemporaryDirectory(String prefix, CleanupMode cleanupMode) throws IOException {
        this.initialize(prefix, cleanupMode);
    }

    private void initialize(String prefix, CleanupMode cleanupMode) throws IOException {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is null");
        }
        if (prefix.trim().isEmpty()) {
            throw new IllegalArgumentException("prefix is blank");
        }
        if (cleanupMode == null) {
            throw new IllegalArgumentException("cleanupMode is null");
        }
        this.path = Files.createTempDirectory(prefix.trim() + UUID.randomUUID(), new FileAttribute[0]);
        if (cleanupMode == CleanupMode.ALWAYS) {
            this.registerShutdownHook(this.path);
        }
    }

    public File file() {
        return new File(this.path.toString());
    }

    public File toFile() {
        return this.file();
    }

    public Path path() {
        return this.toPath();
    }

    public Path toPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        this.delete();
    }

    public void delete() throws IOException {
        this.deleteRecursively(this.path);
    }

    public File newFile() throws IOException {
        return this.newFile(UUID.randomUUID().toString());
    }

    public File newFile(String name) throws IOException {
        File file = new File(this.path.toFile(), name);
        file.createNewFile();
        return file;
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TemporaryDirectory that = (TemporaryDirectory)object;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }

    private void deleteRecursively(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path directory, IOException ioException) throws IOException {
                Files.delete(directory);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void registerShutdownHook(Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.deleteRecursively(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }

    public static enum CleanupMode {
        ALWAYS,
        NEVER;

    }
}

