/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class TemporaryDirectory
implements AutoCloseable {
    private static final String DEFAULT_DIRECTORY_PREFIX = "verifyica-tmp-";
    private static final Set<PosixFilePermission> DEFAULT_POSIX_FILE_PERMISSIONS = PosixFilePermissions.fromString("rwx------");
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private final Set<PosixFilePermission> posixFilePermissions;
    private final Path path = Files.createTempDirectory("verifyica-tmp-", new FileAttribute[0]);

    private TemporaryDirectory(Set<PosixFilePermission> posixFilePermissions) throws IOException {
        this.posixFilePermissions = new HashSet<PosixFilePermission>(posixFilePermissions);
        Files.setPosixFilePermissions(this.path, posixFilePermissions);
        this.registerShutdownHook(this.path);
    }

    public File toFile() {
        return this.path.toFile();
    }

    public Path toPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        this.delete();
    }

    public void delete() throws IOException {
        this.deleteRecursively(this.path);
    }

    public File newFile() throws IOException {
        return this.newFile(this.posixFilePermissions);
    }

    public File newFile(Set<PosixFilePermission> posixFilePermissions) throws IOException {
        File file;
        if (posixFilePermissions == null) {
            throw new IllegalArgumentException("posixFilePermissions is null");
        }
        if (posixFilePermissions.isEmpty()) {
            throw new IllegalArgumentException("posixFilePermissions is empty");
        }
        while (!(file = new File(this.path.toFile(), TemporaryDirectory.generateRandomId())).createNewFile()) {
        }
        Files.setPosixFilePermissions(file.toPath(), posixFilePermissions);
        return file;
    }

    public String toString() {
        return this.path.toString();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TemporaryDirectory that = (TemporaryDirectory)object;
        return Objects.equals(this.path, that.path);
    }

    public int hashCode() {
        return Objects.hashCode(this.path);
    }

    private void deleteRecursively(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path directory, IOException ioException) throws IOException {
                Files.delete(directory);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static TemporaryDirectory newDirectory() throws IOException {
        return TemporaryDirectory.newDirectory(DEFAULT_POSIX_FILE_PERMISSIONS);
    }

    public static TemporaryDirectory newDirectory(Set<PosixFilePermission> posixFilePermissions) throws IOException {
        if (posixFilePermissions == null) {
            throw new IllegalArgumentException("posixFilePermissions is null");
        }
        if (posixFilePermissions.isEmpty()) {
            throw new IllegalArgumentException("posixFilePermissions is empty");
        }
        return new TemporaryDirectory(posixFilePermissions);
    }

    private static String generateRandomId() {
        return String.valueOf(Long.toUnsignedString(SECURE_RANDOM.nextLong()));
    }

    private void registerShutdownHook(Path path) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.deleteRecursively(path);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }));
    }
}

