/*
 * Decompiled with CFR 0.152.
 */
package 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ConditionalBuilder;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.SemaphoreExecutor;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadCustomizer;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadProviderFactory;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadTool;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

public class ExecutorTool {
    public static boolean hasVirtualThreads() {
        return ThreadTool.hasVirtualThreads();
    }

    public static boolean hasSafeVirtualThreads() {
        return ThreadTool.hasSafeVirtualThreads();
    }

    public static <T> ConditionalBuilder<T> ifVirtualThreads(Supplier<T> positiveSupplier) {
        return ThreadTool.ifVirtualThreads(positiveSupplier);
    }

    public static <T> ConditionalBuilder<T> ifSafeVirtualThreads(Supplier<T> positiveSupplier) {
        return ThreadTool.ifSafeVirtualThreads(positiveSupplier);
    }

    public static ExecutorService newThreadPerTaskExecutor(ThreadFactory threadFactory) {
        return ThreadProviderFactory.getThreadProvider().newThreadPerTaskExecutor(threadFactory);
    }

    public static ExecutorService newVirtualThreadPerTaskExecutor() {
        return ThreadProviderFactory.getThreadProvider().newVirtualThreadPerTaskExecutor();
    }

    public static ExecutorService newVirtualThreadPerTaskExecutor(ThreadCustomizer threadCustomizer) {
        return ThreadProviderFactory.getThreadProvider().newVirtualThreadPerTaskExecutor(threadCustomizer, null);
    }

    public static ExecutorService newVirtualThreadPerTaskExecutor(ThreadFactory threadFactory) {
        Objects.requireNonNull(threadFactory);
        ThreadCustomizer threadCustomizer = thread -> {};
        return ThreadProviderFactory.getThreadProvider().newVirtualThreadPerTaskExecutor(threadCustomizer, threadFactory);
    }

    public static ExecutorService newSemaphoreVirtualExecutor(int permits) {
        ExecutorService executor = ThreadProviderFactory.getThreadProvider().newVirtualThreadPerTaskExecutor();
        return new SemaphoreExecutor(executor, permits);
    }

    public static ExecutorService newSemaphoreVirtualExecutor(int permits, Duration acquireTimeout) {
        ExecutorService executor = ThreadProviderFactory.getThreadProvider().newVirtualThreadPerTaskExecutor();
        return new SemaphoreExecutor(executor, permits, acquireTimeout);
    }

    private ExecutorTool() {
        throw new AssertionError();
    }
}

