/*
 * Decompiled with CFR 0.152.
 */
package 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadBuilders8;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadCustomizer;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadFeature;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadProvider;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadProviderConfig;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadTool;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class ThreadProvider8
implements ThreadProvider {
    private final ThreadProviderConfig config = new ThreadProviderConfig();

    ThreadProvider8() {
    }

    @Override
    public ThreadProviderConfig getConfig() {
        return this.config;
    }

    @Override
    public boolean hasVirtualThreads() {
        this.config.enforceCompatibilityPolicy(ThreadFeature.HAS_VIRTUAL_THREADS);
        return false;
    }

    @Override
    public boolean hasSafeVirtualThreads() {
        this.config.enforceCompatibilityPolicy(ThreadFeature.HAS_SAFE_VIRTUAL_THREADS);
        return false;
    }

    @Override
    public boolean isVirtual(Thread thread) {
        this.config.enforceCompatibilityPolicy(ThreadFeature.IS_VIRTUAL);
        return false;
    }

    @Override
    public Thread startVirtualThread(Runnable task) {
        this.config.enforceCompatibilityPolicy(ThreadFeature.START_VIRTUAL_THREAD);
        Thread thread = this.unstartedVirtualThread(task);
        thread.start();
        return thread;
    }

    @Override
    public Thread unstartedVirtualThread(Runnable task) {
        this.config.enforceCompatibilityPolicy(ThreadFeature.UNSTARTED_VIRTUAL_THREAD);
        Thread thread = new Thread(task);
        this.config.getThreadCustomizer().customize(thread);
        return thread;
    }

    @Override
    public ExecutorService newThreadPerTaskExecutor(ThreadFactory threadFactory) {
        this.config.enforceCompatibilityPolicy(ThreadFeature.NEW_THREAD_PER_TASK_EXECUTOR);
        return new ThreadPerTaskExecutor(threadFactory);
    }

    @Override
    public ExecutorService newVirtualThreadPerTaskExecutor() {
        this.config.enforceCompatibilityPolicy(ThreadFeature.NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR);
        return this.newThreadPerTaskExecutor(this::unstartedVirtualThread);
    }

    @Override
    public ExecutorService newVirtualThreadPerTaskExecutor(ThreadCustomizer threadCustomizer, ThreadFactory threadFactory) {
        this.config.enforceCompatibilityPolicy(ThreadFeature.NEW_VIRTUAL_THREAD_PER_TASK_EXECUTOR);
        ThreadFactory actualFactory = threadFactory == null ? this::unstartedVirtualThread : threadFactory;
        return this.newThreadPerTaskExecutor(threadCustomizer.asThreadFactory(actualFactory));
    }

    @Override
    public ThreadTool.Builder.OfPlatform ofPlatform() {
        this.config.enforceCompatibilityPolicy(ThreadFeature.OF_PLATFORM);
        return new ThreadBuilders8.PlatformThreadBuilder(this.config);
    }

    @Override
    public ThreadTool.Builder.OfVirtual ofVirtual() {
        this.config.enforceCompatibilityPolicy(ThreadFeature.OF_VIRTUAL);
        return new ThreadBuilders8.VirtualThreadBuilder();
    }

    private static class ThreadPerTaskExecutor
    extends AbstractExecutorService
    implements ExecutorService {
        private final ThreadFactory threadFactory;
        private volatile boolean isShutdown;
        private final Set<Thread> threads = Collections.newSetFromMap(new ConcurrentHashMap());

        public ThreadPerTaskExecutor(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
        }

        @Override
        public void execute(Runnable command) {
            if (this.isShutdown) {
                throw new IllegalArgumentException("Executor is shut down");
            }
            Thread thread = this.threadFactory.newThread(() -> {
                try {
                    command.run();
                }
                finally {
                    this.threads.remove(Thread.currentThread());
                }
            });
            this.threads.add(thread);
            thread.start();
        }

        @Override
        public void shutdown() {
            this.isShutdown = true;
        }

        @Override
        public List<Runnable> shutdownNow() {
            this.shutdown();
            this.threads.forEach(Thread::interrupt);
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return this.isShutdown;
        }

        @Override
        public boolean isTerminated() {
            return this.isShutdown();
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            long timeoutMs = unit.toMillis(timeout);
            for (Thread thread : this.threads) {
                if (timeoutMs <= 0L) {
                    return false;
                }
                long start = System.currentTimeMillis();
                thread.join(timeoutMs);
                long diff = System.currentTimeMillis() - start;
                timeoutMs -= diff;
            }
            return true;
        }
    }
}

