/*
 * Decompiled with CFR 0.152.
 */
package 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.CompatibilityPolicy;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.IncompatibilityException;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadCustomizer;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadFeature;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadProviderFactory;
import java.util.EnumMap;
import java.util.Map;

public class ThreadProviderConfig {
    private final Map<ThreadFeature, CompatibilityPolicy> policies = new EnumMap<ThreadFeature, CompatibilityPolicy>(ThreadFeature.class);
    private ThreadCustomizer threadCustomizer = thread -> {};

    public ThreadProviderConfig throwExceptionWhen(ThreadFeature threadFeature) {
        return this.setCompatibilityPolicy(threadFeature, CompatibilityPolicy.THROW_EXCEPTION);
    }

    public CompatibilityPolicy getCompatibilityPolicy(ThreadFeature threadFeature) {
        return this.policies.getOrDefault((Object)threadFeature, CompatibilityPolicy.BEST_EFFORT);
    }

    public ThreadProviderConfig setCompatibilityPolicy(ThreadFeature threadFeature, CompatibilityPolicy policy) {
        this.policies.put(threadFeature, policy);
        return this;
    }

    public ThreadCustomizer getThreadCustomizer() {
        return this.threadCustomizer;
    }

    public void setThreadCustomizer(ThreadCustomizer threadCustomizer) {
        this.threadCustomizer = threadCustomizer;
    }

    void reset() {
        this.policies.clear();
    }

    void enforceCompatibilityPolicy(ThreadFeature threadFeature) {
        CompatibilityPolicy compatibilityPolicy;
        if (!ThreadProviderFactory.isJava21() && (compatibilityPolicy = this.getCompatibilityPolicy(threadFeature)) == CompatibilityPolicy.THROW_EXCEPTION) {
            throw new IncompatibilityException("Java21 Virtual Threads feature unexpectedly accessed in Java8+ VM");
        }
    }
}

