/*
 * Decompiled with CFR 0.152.
 */
package 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ConditionalBuilder;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadProvider;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadProviderConfig;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class ThreadTool {
    private static final AtomicInteger threadNumber = new AtomicInteger();

    public static ThreadProviderConfig getConfig() {
        return ThreadProvider.getThreadProvider().getConfig();
    }

    public static boolean hasVirtualThreads() {
        return ThreadProvider.getThreadProvider().hasVirtualThreads();
    }

    public static boolean hasSafeVirtualThreads() {
        return ThreadProvider.getThreadProvider().hasSafeVirtualThreads();
    }

    public static <T> ConditionalBuilder<T> ifVirtualThreads(Supplier<T> positiveSupplier) {
        return ConditionalBuilder.conditionalOn(ThreadTool.hasVirtualThreads()).ifTrue(positiveSupplier);
    }

    public static <T> ConditionalBuilder<T> ifSafeVirtualThreads(Supplier<T> positiveSupplier) {
        return ConditionalBuilder.conditionalOn(ThreadTool.hasSafeVirtualThreads()).ifTrue(positiveSupplier);
    }

    public static boolean isVirtual(Thread thread) {
        return ThreadProvider.getThreadProvider().isVirtual(thread);
    }

    public static boolean isVirtual() {
        return ThreadProvider.getThreadProvider().isVirtual(Thread.currentThread());
    }

    public static Thread startVirtualThread(Runnable task) {
        return ThreadProvider.getThreadProvider().startVirtualThread(task);
    }

    public static Thread unstartedVirtualThread(Runnable task) {
        return ThreadProvider.getThreadProvider().unstartedVirtualThread(task);
    }

    public static Builder.OfPlatform ofPlatform() {
        return ThreadProvider.getThreadProvider().ofPlatform();
    }

    public static Builder.OfVirtual ofVirtual() {
        return ThreadProvider.getThreadProvider().ofVirtual();
    }

    static String genThreadName() {
        return "Thread-" + threadNumber.getAndIncrement();
    }

    private ThreadTool() {
        throw new AssertionError();
    }

    public static interface Builder {
        public Builder name(String var1);

        public Builder name(String var1, long var2);

        public Builder inheritInheritableThreadLocals(boolean var1);

        public Builder uncaughtExceptionHandler(Thread.UncaughtExceptionHandler var1);

        public Thread unstarted(Runnable var1);

        public Thread start(Runnable var1);

        public ThreadFactory factory();

        public static interface OfVirtual
        extends Builder {
        }

        public static interface OfPlatform
        extends Builder {
            public OfPlatform group(ThreadGroup var1);

            public OfPlatform daemon(boolean var1);

            default public OfPlatform daemon() {
                return this.daemon(true);
            }

            public OfPlatform priority(int var1);

            public OfPlatform stackSize(long var1);
        }
    }
}

