/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.SemaphoreExecutor;
import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadNameRunnable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.EngineDescriptor;
import org.verifyica.api.ClassInterceptor;
import org.verifyica.api.Configuration;
import org.verifyica.api.ExtendedMap;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.common.EphemeralExecutorService;
import org.verifyica.engine.common.PlatformThreadFactory;
import org.verifyica.engine.common.StackTracePrinter;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.common.VirtualThreadFactory;
import org.verifyica.engine.configuration.ConcreteConfiguration;
import org.verifyica.engine.context.ConcreteEngineContext;
import org.verifyica.engine.descriptor.ClassTestDescriptor;
import org.verifyica.engine.descriptor.TestableTestDescriptor;
import org.verifyica.engine.exception.EngineConfigurationException;
import org.verifyica.engine.exception.EngineException;
import org.verifyica.engine.exception.TestClassDefinitionException;
import org.verifyica.engine.inject.Injector;
import org.verifyica.engine.interceptor.ClassInterceptorRegistry;
import org.verifyica.engine.interceptor.EngineInterceptorRegistry;
import org.verifyica.engine.listener.ChainedEngineExecutionListener;
import org.verifyica.engine.listener.TracingEngineExecutionListener;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.resolver.EngineDiscoveryRequestResolver;
import org.verifyica.engine.support.ExecutorServiceSupport;
import org.verifyica.engine.support.HashSupport;
import org.verifyica.engine.support.ListSupport;

public class VerifyicaTestEngine
implements TestEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(VerifyicaTestEngine.class);
    private static final String UNKNOWN_VERSION = "unknown";
    private static final String DISPLAY_NAME = "Verifyica";
    private static final String ID = "Verifyica".toLowerCase(Locale.ENGLISH);
    private static final String GROUP_ID = "org.verifyica";
    private static final String ARTIFACT_ID = "engine";
    private static final String VERSION = VerifyicaTestEngine.version();
    private static final String UNIQUE_ID = "[engine:" + ID + "]";
    private static final String ENGINE_PROPERTIES_RESOURCE = "/engine.properties";
    private static final String ENGINE_PROPERTIES_VERSION_KEY = "version";
    private final List<Throwable> throwables = new ArrayList<Throwable>();
    private Configuration configuration;

    public String getId() {
        return ID;
    }

    public Optional<String> getGroupId() {
        return Optional.of(GROUP_ID);
    }

    public Optional<String> getArtifactId() {
        return Optional.of(ARTIFACT_ID);
    }

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public static String staticGetVersion() {
        return VERSION;
    }

    public TestDescriptor discover(EngineDiscoveryRequest engineDiscoveryRequest, UniqueId uniqueId) {
        if (!UNIQUE_ID.equals(uniqueId.toString()) || VerifyicaTestEngine.isRunningViaMavenSurefirePlugin()) {
            return new EngineDescriptor(uniqueId, "Verifyica disabled under Maven Surefire");
        }
        Stopwatch stopwatch = new Stopwatch();
        LOGGER.trace("discover()");
        try {
            this.configuration = ConcreteConfiguration.getInstance();
            EngineDescriptor engineDescriptor = new EngineDescriptor(uniqueId, DISPLAY_NAME);
            new EngineDiscoveryRequestResolver().resolveSelectors(engineDiscoveryRequest, (TestDescriptor)engineDescriptor);
            LOGGER.trace("discovered [%d] test classes", engineDescriptor.getChildren().size());
            LOGGER.trace("discover() elapsedTime [%d] ms", stopwatch.elapsed().toMillis());
            return engineDescriptor;
        }
        catch (TestClassDefinitionException e) {
            if (!VerifyicaTestEngine.isRunningViaVerifyicaMavenPlugin()) {
                System.err.println(e.getMessage());
                System.exit(1);
            }
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new EngineException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionRequest executionRequest) {
        TestExecutionResult testExecutionResult;
        if (executionRequest.getRootTestDescriptor().getChildren().isEmpty()) {
            return;
        }
        Stopwatch stopwatch = new Stopwatch();
        LOGGER.trace("execute()");
        EngineExecutionListener engineExecutionListener = null;
        ConcreteEngineContext engineContext = null;
        EngineInterceptorRegistry engineInterceptorRegistry = null;
        ClassInterceptorRegistry classInterceptorRegistry = null;
        try {
            if (LOGGER.isTraceEnabled()) {
                VerifyicaTestEngine.traceEngineDescriptor(executionRequest.getRootTestDescriptor());
            }
            ExecutorService classExecutorService = VerifyicaTestEngine.createEngineClassExecutorService(this.configuration);
            ExecutorService argumentExecutorService = VerifyicaTestEngine.createEngineArgumentExecutorService(this.configuration);
            engineExecutionListener = VerifyicaTestEngine.configureEngineExecutionListeners(executionRequest);
            engineInterceptorRegistry = new EngineInterceptorRegistry(this.configuration);
            classInterceptorRegistry = new ClassInterceptorRegistry(this.configuration);
            engineContext = new ConcreteEngineContext(this.configuration, VerifyicaTestEngine.staticGetVersion());
            try {
                engineInterceptorRegistry.initialize(engineContext);
                classInterceptorRegistry.initialize(engineContext);
                engineExecutionListener.executionStarted(executionRequest.getRootTestDescriptor());
                List testableTestDescriptors = executionRequest.getRootTestDescriptor().getChildren().stream().filter(TestableTestDescriptor.TESTABLE_TEST_DESCRIPTOR_FILTER).map(TestableTestDescriptor.TESTABLE_TEST_DESCRIPTOR_MAPPER).collect(Collectors.toList());
                ArrayList futures = new ArrayList();
                for (TestableTestDescriptor testableTestDescriptor : testableTestDescriptors) {
                    Class<?> testClass = ((ClassTestDescriptor)testableTestDescriptor).getTestClass();
                    List<ClassInterceptor> classInterceptors = classInterceptorRegistry.getClassInterceptors(engineContext, testClass);
                    List<ClassInterceptor> classInterceptorsReversed = ListSupport.copyAndReverse(classInterceptors);
                    Injector.inject("engineExecutionListener", (Object)engineExecutionListener, (Object)testableTestDescriptor);
                    Injector.inject("engineContext", (Object)engineContext, (Object)testableTestDescriptor);
                    Injector.inject("argumentExecutorService", (Object)argumentExecutorService, (Object)testableTestDescriptor);
                    Injector.inject("classInterceptors", classInterceptors, (Object)testableTestDescriptor);
                    Injector.inject("classInterceptorsReversed", classInterceptorsReversed, (Object)testableTestDescriptor);
                    String hash = HashSupport.alphanumeric(6);
                    String threadName = hash + "/" + hash;
                    ThreadNameRunnable threadNameRunnable = new ThreadNameRunnable(threadName, testableTestDescriptor::test);
                    Future<?> future = classExecutorService.submit(threadNameRunnable);
                    futures.add(future);
                }
                ExecutorServiceSupport.waitForAllFutures(futures, classExecutorService);
            }
            catch (Throwable t) {
                try {
                    StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
                    this.throwables.add(t);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ExecutorServiceSupport.shutdownAndAwaitTermination(argumentExecutorService);
                    ExecutorServiceSupport.shutdownAndAwaitTermination(classExecutorService);
                    ExtendedMap map = engineContext.getMap();
                    Set entrySet = map.entrySet();
                    for (Map.Entry entry : entrySet) {
                        if (!(entry.getValue() instanceof AutoCloseable)) continue;
                        try {
                            ((AutoCloseable)entry.getValue()).close();
                        }
                        catch (Throwable t2) {
                            StackTracePrinter.printStackTrace(t2, AnsiColor.TEXT_RED_BOLD, System.err);
                            this.throwables.add(t2);
                        }
                    }
                    map.clear();
                }
            }
            ExecutorServiceSupport.shutdownAndAwaitTermination(argumentExecutorService);
            ExecutorServiceSupport.shutdownAndAwaitTermination(classExecutorService);
            ExtendedMap map = engineContext.getMap();
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                if (!(entry.getValue() instanceof AutoCloseable)) continue;
                try {
                    ((AutoCloseable)entry.getValue()).close();
                }
                catch (Throwable t) {
                    StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
                    this.throwables.add(t);
                }
            }
            map.clear();
            if (classInterceptorRegistry != null) {
                classInterceptorRegistry.destroy(engineContext);
            }
            if (engineInterceptorRegistry != null) {
                engineInterceptorRegistry.destroy(engineContext);
            }
            testExecutionResult = this.throwables.isEmpty() ? TestExecutionResult.successful() : TestExecutionResult.failed((Throwable)this.throwables.get(0));
        }
        catch (Throwable throwable) {
            if (classInterceptorRegistry != null) {
                classInterceptorRegistry.destroy(engineContext);
            }
            if (engineInterceptorRegistry != null) {
                engineInterceptorRegistry.destroy(engineContext);
            }
            TestExecutionResult testExecutionResult2 = this.throwables.isEmpty() ? TestExecutionResult.successful() : TestExecutionResult.failed((Throwable)this.throwables.get(0));
            engineExecutionListener.executionFinished(executionRequest.getRootTestDescriptor(), testExecutionResult2);
            LOGGER.trace("execute() elapsedTime [%d] ms", stopwatch.elapsed().toMillis());
            throw throwable;
        }
        TestExecutionResult testExecutionResult3 = testExecutionResult;
        engineExecutionListener.executionFinished(executionRequest.getRootTestDescriptor(), testExecutionResult3);
        LOGGER.trace("execute() elapsedTime [%d] ms", stopwatch.elapsed().toMillis());
    }

    private static String version() {
        String value = UNKNOWN_VERSION;
        try (InputStream inputStream = VerifyicaTestEngine.class.getResourceAsStream(ENGINE_PROPERTIES_RESOURCE);){
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                value = properties.getProperty(ENGINE_PROPERTIES_VERSION_KEY).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    private static EngineExecutionListener configureEngineExecutionListeners(ExecutionRequest executionRequest) {
        LOGGER.trace("configureEngineExecutionListeners()");
        if (VerifyicaTestEngine.isRunningViaVerifyicaMavenPlugin()) {
            return executionRequest.getEngineExecutionListener();
        }
        return new ChainedEngineExecutionListener(new TracingEngineExecutionListener(), executionRequest.getEngineExecutionListener());
    }

    private static boolean isRunningViaVerifyicaMavenPlugin() {
        boolean isRunningViaVerifyicaMavenPlugin = "true".equals(System.getProperty("verifyica.maven.plugin"));
        LOGGER.trace("isRunningViaVerifyicaMavenPlugin [%b]", isRunningViaVerifyicaMavenPlugin);
        return isRunningViaVerifyicaMavenPlugin;
    }

    private static boolean isRunningViaMavenSurefirePlugin() {
        if (System.getProperty("surefire.test.class.path") != null) {
            return true;
        }
        boolean isRunningViaMavenSurefirePlugin = Arrays.stream(Thread.currentThread().getStackTrace()).anyMatch(stackTraceElement -> stackTraceElement.getClassName().startsWith("6bc6660d778dec84d62bc72b295ffd7b.org.apache.maven.surefire"));
        LOGGER.trace("isRunningViaMavenSurefirePlugin [%b]", isRunningViaMavenSurefirePlugin);
        return isRunningViaMavenSurefirePlugin;
    }

    private static void traceEngineDescriptor(TestDescriptor testDescriptor) {
        VerifyicaTestEngine.traceTestDescriptor(testDescriptor, 0);
    }

    private static void traceTestDescriptor(TestDescriptor testDescriptor, int level) {
        LOGGER.trace(String.join((CharSequence)" ", Collections.nCopies(level, " ")) + testDescriptor);
        testDescriptor.getChildren().forEach(childTestDescriptor -> VerifyicaTestEngine.traceTestDescriptor(childTestDescriptor, level + 2));
    }

    private static ExecutorService createEngineClassExecutorService(Configuration configuration) {
        LOGGER.trace("createEngineClassExecutorService()");
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        String engineThreadType = configuration.getProperties().getProperty("verifyica.engine.thread.type", "virtual");
        int engineClassParallelism = VerifyicaTestEngine.getEngineClassParallelism(configuration);
        ThreadFactory threadFactory = VerifyicaTestEngine.createThreadFactory(configuration);
        if ("platform-ephemeral".equals(engineThreadType.trim())) {
            LOGGER.trace("creating EphemeralExecutorService");
            return new SemaphoreExecutor((ExecutorService)new EphemeralExecutorService(threadFactory), new Semaphore(engineClassParallelism));
        }
        LOGGER.trace("creating ThreadPoolExecutor");
        return new ThreadPoolExecutor(engineClassParallelism, engineClassParallelism, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(availableProcessors * 4), threadFactory, (r, executor) -> {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Task was interrupted while waiting for space in the queue", e);
            }
        });
    }

    private static ExecutorService createEngineArgumentExecutorService(Configuration configuration) {
        LOGGER.trace("createEngineClassExecutorService()");
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        String engineThreadType = configuration.getProperties().getProperty("verifyica.engine.thread.type", "virtual");
        int engineArgumentParallelism = VerifyicaTestEngine.getEngineArgumentParallelism(configuration);
        ThreadFactory threadFactory = VerifyicaTestEngine.createThreadFactory(configuration);
        if ("platform-ephemeral".equals(engineThreadType.trim())) {
            LOGGER.trace("creating EphemeralExecutorService");
            return new SemaphoreExecutor((ExecutorService)new EphemeralExecutorService(threadFactory), new Semaphore(engineArgumentParallelism));
        }
        LOGGER.trace("creating ThreadPoolExecutor");
        return new ThreadPoolExecutor(engineArgumentParallelism, engineArgumentParallelism, Long.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(availableProcessors * 4), (r, executor) -> {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Task was interrupted while waiting for space in the queue", e);
            }
        });
    }

    private static ThreadFactory createThreadFactory(Configuration configuration) {
        LOGGER.trace("createThreadFactory()");
        String engineThreadType = configuration.getProperties().getProperty("verifyica.engine.thread.type", "virtual");
        LOGGER.trace("engineThreadType [%s]", engineThreadType);
        if ("platform".equals(engineThreadType.trim()) || "platform-ephemeral".equals(engineThreadType.trim())) {
            LOGGER.trace("creating PlatformThreadFactory");
            return new PlatformThreadFactory();
        }
        LOGGER.trace("creating VirtualThreadFactory");
        return new VirtualThreadFactory();
    }

    private static int getEngineClassParallelism(Configuration configuration) {
        LOGGER.trace("getEngineClassParallelism()");
        int engineClassParallelism = Optional.ofNullable(configuration.getProperties().getProperty("verifyica.engine.class.parallelism")).map(value -> {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < 1) {
                    throw new EngineConfigurationException(String.format("Invalid %s value [%d]", "verifyica.engine.class.parallelism", intValue));
                }
                return intValue;
            }
            catch (NumberFormatException e) {
                throw new EngineConfigurationException(String.format("Invalid %s value [%s]", "verifyica.engine.class.parallelism", value), e);
            }
        }).orElse(Runtime.getRuntime().availableProcessors());
        LOGGER.trace("engineClassParallelism [%d]", engineClassParallelism);
        return engineClassParallelism;
    }

    private static int getEngineArgumentParallelism(Configuration configuration) {
        LOGGER.trace("getEngineArgumentParallelism()");
        int engineClassParallelism = VerifyicaTestEngine.getEngineClassParallelism(configuration);
        int engineArgumentParallelism = Optional.ofNullable(configuration.getProperties().getProperty("verifyica.engine.argument.parallelism")).map(value -> {
            try {
                int intValue = Integer.parseInt(value);
                if (intValue < 1) {
                    throw new EngineConfigurationException(String.format("Invalid %s value [%d]", "verifyica.engine.argument.parallelism", intValue));
                }
                return intValue;
            }
            catch (NumberFormatException e) {
                throw new EngineConfigurationException(String.format("Invalid %s value [%s]", "verifyica.engine.argument.parallelism", value), e);
            }
        }).orElse(engineClassParallelism);
        if (engineArgumentParallelism < engineClassParallelism) {
            LOGGER.warn("[%s] is less than [%s], setting [%s] to [%d]", "verifyica.engine.argument.parallelism", "verifyica.engine.class.parallelism", "verifyica.engine.argument.parallelism", engineClassParallelism);
            engineArgumentParallelism = engineClassParallelism;
        }
        LOGGER.trace("engineArgumentParallelism [%d]", engineArgumentParallelism);
        return engineArgumentParallelism;
    }
}

