/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.io.Console;
import java.util.Objects;
import java.util.regex.Pattern;
import org.verifyica.engine.common.Precondition;

public class AnsiColor {
    private static final String PREFIX = "verifyica.test.engine";
    private static final String MAVEN_PLUGIN_MODE = "verifyica.test.engine.maven.plugin.mode";
    private static final String MAVEN_PLUGIN_BATCH = "verifyica.test.engine.maven.plugin.batch";
    private static final Pattern ANSI_PATTERN;
    private static final String ANSI_COLOR_ENVIRONMENT_VARIABLE = "ANSI_COLOR";
    private static final String NO_COLOR_ENVIRONMENT_VARIABLE = "NO_COLOR";
    private static final String EMPTY_STRING = "";
    public static final AnsiColor NONE;
    public static final AnsiColor TEXT_BLACK;
    public static final AnsiColor TEXT_RED;
    public static final AnsiColor TEXT_GREEN;
    public static final AnsiColor TEXT_YELLOW;
    public static final AnsiColor TEXT_BLUE;
    public static final AnsiColor TEXT_PURPLE;
    public static final AnsiColor TEXT_CYAN;
    public static final AnsiColor TEXT_WHITE;
    public static final AnsiColor TEXT_BLACK_BOLD;
    public static final AnsiColor TEXT_RED_BOLD;
    public static final AnsiColor TEXT_GREEN_BOLD;
    public static final AnsiColor TEXT_YELLOW_BOLD;
    public static final AnsiColor TEXT_BLUE_BOLD;
    public static final AnsiColor TEXT_PURPLE_BOLD;
    public static final AnsiColor TEXT_CYAN_BOLD;
    public static final AnsiColor TEXT_WHITE_BOLD;
    public static final AnsiColor TEXT_BLACK_UNDERLINED;
    public static final AnsiColor TEXT_RED_UNDERLINED;
    public static final AnsiColor TEXT_GREEN_UNDERLINED;
    public static final AnsiColor TEXT_YELLOW_UNDERLINED;
    public static final AnsiColor TEXT_BLUE_UNDERLINED;
    public static final AnsiColor TEXT_PURPLE_UNDERLINED;
    public static final AnsiColor TEXT_CYAN_UNDERLINED;
    public static final AnsiColor TEXT_WHITE_UNDERLINED;
    public static final AnsiColor TEXT_BLACK_BRIGHT;
    public static final AnsiColor TEXT_RED_BRIGHT;
    public static final AnsiColor TEXT_GREEN_BRIGHT;
    public static final AnsiColor TEXT_YELLOW_BRIGHT;
    public static final AnsiColor TEXT_BLUE_BRIGHT;
    public static final AnsiColor TEXT_PURPLE_BRIGHT;
    public static final AnsiColor TEXT_CYAN_BRIGHT;
    public static final AnsiColor TEXT_WHITE_BRIGHT;
    public static final AnsiColor TEXT_BLACK_BOLD_BRIGHT;
    public static final AnsiColor TEXT_RED_BOLD_BRIGHT;
    public static final AnsiColor TEXT_GREEN_BOLD_BRIGHT;
    public static final AnsiColor TEXT_YELLOW_BOLD_BRIGHT;
    public static final AnsiColor TEXT_BLUE_BOLD_BRIGHT;
    public static final AnsiColor TEXT_PURPLE_BOLD_BRIGHT;
    public static final AnsiColor TEXT_CYAN_BOLD_BRIGHT;
    public static final AnsiColor TEXT_WHITE_BOLD_BRIGHT;
    public static final AnsiColor BACKGROUND_BLACK;
    public static final AnsiColor BACKGROUND_RED;
    public static final AnsiColor BACKGROUND_GREEN;
    public static final AnsiColor BACKGROUND_YELLOW;
    public static final AnsiColor BACKGROUND_BLUE;
    public static final AnsiColor BACKGROUND_PURPLE;
    public static final AnsiColor BACKGROUND_CYAN;
    public static final AnsiColor BACKGROUND_WHITE;
    public static final AnsiColor BACKGROUND_BLACK_BRIGHT;
    public static final AnsiColor BACKGROUND_RED_BRIGHT;
    public static final AnsiColor BACKGROUND_GREEN_BRIGHT;
    public static final AnsiColor BACKGROUND_YELLOW_BRIGHT;
    public static final AnsiColor BACKGROUND_BLUE_BRIGHT;
    public static final AnsiColor BACKGROUND_PURPLE_BRIGHT;
    public static final AnsiColor BACKGROUND_CYAN_BRIGHT;
    public static final AnsiColor BACKGROUND_WHITE_BRIGHT;
    private static boolean ANSI_COLOR_SUPPORTED;
    private final String escapeSequence;

    private AnsiColor(String escapeSequence) {
        Precondition.notNullOrBlank(escapeSequence, "escapeSequence is null", "escapeSequence is blank");
        this.escapeSequence = escapeSequence;
    }

    public String wrap(Object object) {
        return ANSI_COLOR_SUPPORTED ? this.escapeSequence + object + NONE : String.valueOf(object);
    }

    public String toString() {
        return ANSI_COLOR_SUPPORTED ? this.escapeSequence : EMPTY_STRING;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnsiColor ansiColor = (AnsiColor)o;
        return Objects.equals(this.escapeSequence, ansiColor.escapeSequence);
    }

    public int hashCode() {
        return Objects.hashCode(this.escapeSequence);
    }

    public static String stripAnsiEscapeSequences(String string) {
        return string == null ? null : ANSI_PATTERN.matcher(string).replaceAll(EMPTY_STRING);
    }

    public static boolean isSupported() {
        return ANSI_COLOR_SUPPORTED;
    }

    public static void setSupported(boolean ansiColorSupported) {
        ANSI_COLOR_SUPPORTED = ansiColorSupported;
    }

    public static AnsiColor ofSequence(String escapeSequence) {
        Precondition.notNullOrBlank(escapeSequence, "escapeSequence is null", "escapeSequence is blank");
        return new AnsiColor(escapeSequence);
    }

    static {
        String ansiColorForce;
        ANSI_PATTERN = Pattern.compile("\\u001B\\[[;\\d]*m");
        NONE = new AnsiColor("\u001b[0m");
        TEXT_BLACK = new AnsiColor("\u001b[0;30m");
        TEXT_RED = new AnsiColor("\u001b[0;38;5;160m");
        TEXT_GREEN = new AnsiColor("\u001b[0;32m");
        TEXT_YELLOW = new AnsiColor("\u001b[0;33m");
        TEXT_BLUE = new AnsiColor("\u001b[0;34m");
        TEXT_PURPLE = new AnsiColor("\u001b[0;35m");
        TEXT_CYAN = new AnsiColor("\u001b[0;36m");
        TEXT_WHITE = new AnsiColor("\u001b[0;37m");
        TEXT_BLACK_BOLD = new AnsiColor("\u001b[1;30m");
        TEXT_RED_BOLD = new AnsiColor("\u001b[1;31m");
        TEXT_GREEN_BOLD = new AnsiColor("\u001b[1;32m");
        TEXT_YELLOW_BOLD = new AnsiColor("\u001b[1;33m");
        TEXT_BLUE_BOLD = new AnsiColor("\u001b[1;34m");
        TEXT_PURPLE_BOLD = new AnsiColor("\u001b[1;35m");
        TEXT_CYAN_BOLD = new AnsiColor("\u001b[1;36m");
        TEXT_WHITE_BOLD = new AnsiColor("\u001b[1;37m");
        TEXT_BLACK_UNDERLINED = new AnsiColor("\u001b[4;30m");
        TEXT_RED_UNDERLINED = new AnsiColor("\u001b[4;31m");
        TEXT_GREEN_UNDERLINED = new AnsiColor("\u001b[4;32m");
        TEXT_YELLOW_UNDERLINED = new AnsiColor("\u001b[4;33m");
        TEXT_BLUE_UNDERLINED = new AnsiColor("\u001b[4;34m");
        TEXT_PURPLE_UNDERLINED = new AnsiColor("\u001b[4;35m");
        TEXT_CYAN_UNDERLINED = new AnsiColor("\u001b[4;36m");
        TEXT_WHITE_UNDERLINED = new AnsiColor("\u001b[4;37m");
        TEXT_BLACK_BRIGHT = new AnsiColor("\u001b[0;90m");
        TEXT_RED_BRIGHT = new AnsiColor("\u001b[0;38;5;196m");
        TEXT_GREEN_BRIGHT = new AnsiColor("\u001b[0;92m");
        TEXT_YELLOW_BRIGHT = new AnsiColor("\u001b[0;93m");
        TEXT_BLUE_BRIGHT = new AnsiColor("\u001b[0;94m");
        TEXT_PURPLE_BRIGHT = new AnsiColor("\u001b[0;95m");
        TEXT_CYAN_BRIGHT = new AnsiColor("\u001b[0;96m");
        TEXT_WHITE_BRIGHT = new AnsiColor("\u001b[1;97m");
        TEXT_BLACK_BOLD_BRIGHT = new AnsiColor("\u001b[1;90m");
        TEXT_RED_BOLD_BRIGHT = new AnsiColor("\u001b[1;38;5;160m");
        TEXT_GREEN_BOLD_BRIGHT = new AnsiColor("\u001b[1;92m");
        TEXT_YELLOW_BOLD_BRIGHT = new AnsiColor("\u001b[1;93m");
        TEXT_BLUE_BOLD_BRIGHT = new AnsiColor("\u001b[1;94m");
        TEXT_PURPLE_BOLD_BRIGHT = new AnsiColor("\u001b[1;95m");
        TEXT_CYAN_BOLD_BRIGHT = new AnsiColor("\u001b[1;96m");
        TEXT_WHITE_BOLD_BRIGHT = new AnsiColor("\u001b[1;97m");
        BACKGROUND_BLACK = new AnsiColor("\u001b[40m");
        BACKGROUND_RED = new AnsiColor("\u001b[41m");
        BACKGROUND_GREEN = new AnsiColor("\u001b[42m");
        BACKGROUND_YELLOW = new AnsiColor("\u001b[43m");
        BACKGROUND_BLUE = new AnsiColor("\u001b[44m");
        BACKGROUND_PURPLE = new AnsiColor("\u001b[45m");
        BACKGROUND_CYAN = new AnsiColor("\u001b[46m");
        BACKGROUND_WHITE = new AnsiColor("\u001b[47m");
        BACKGROUND_BLACK_BRIGHT = new AnsiColor("\u001b[0;100m");
        BACKGROUND_RED_BRIGHT = new AnsiColor("\u001b[0;101m");
        BACKGROUND_GREEN_BRIGHT = new AnsiColor("\u001b[0;102m");
        BACKGROUND_YELLOW_BRIGHT = new AnsiColor("\u001b[0;103m");
        BACKGROUND_BLUE_BRIGHT = new AnsiColor("\u001b[0;104m");
        BACKGROUND_PURPLE_BRIGHT = new AnsiColor("\u001b[0;105m");
        BACKGROUND_CYAN_BRIGHT = new AnsiColor("\u001b[0;106m");
        BACKGROUND_WHITE_BRIGHT = new AnsiColor("\u001b[0;107m");
        Console console = System.console();
        if (console == null) {
            ANSI_COLOR_SUPPORTED = false;
        } else {
            try {
                ANSI_COLOR_SUPPORTED = (Boolean)Class.forName("java.io.Console").getDeclaredMethod("isTerminal", new Class[0]).invoke((Object)console, new Object[0]);
            }
            catch (Throwable t) {
                ANSI_COLOR_SUPPORTED = true;
            }
        }
        String noColor = System.getenv(NO_COLOR_ENVIRONMENT_VARIABLE);
        if (noColor != null && !noColor.trim().isEmpty()) {
            ANSI_COLOR_SUPPORTED = false;
        }
        if ((ansiColorForce = System.getenv(ANSI_COLOR_ENVIRONMENT_VARIABLE)) != null && !ansiColorForce.trim().isEmpty()) {
            ANSI_COLOR_SUPPORTED = true;
        }
    }
}

