/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.verifyica.engine.common.Precondition;

public class Counter {
    private final String name;
    private final String description;
    private final AtomicLong count;

    public Counter(String name, String description) {
        Precondition.notNullOrBlank(name, "name is null", "name is blank");
        Precondition.notNullOrBlank(description, "description is null", "description is blank");
        this.name = name;
        this.description = description;
        this.count = new AtomicLong(0L);
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public long count() {
        return this.count.get();
    }

    public void increment() {
        this.count.incrementAndGet();
    }

    public void increment(long value) {
        Precondition.isTrue(value >= 0L, "value must be >= 0");
        this.count.addAndGet(value);
    }

    public String toString() {
        return "Counter {name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", count=" + this.count.get() + " }";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Counter)) {
            return false;
        }
        Counter counter = (Counter)o;
        return Objects.equals(this.name, counter.name) && Objects.equals(this.description, counter.description);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description);
    }

    public void register(Map<String, Counter> map) {
        Precondition.notNull(map, "map is null");
        map.put(this.name, this);
    }
}

