/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.util.concurrent.ThreadLocalRandom;

public final class FastId
implements Comparable<FastId> {
    private static final char[] HEX = "0123456789abcdef".toCharArray();
    private final long msb;
    private final long lsb;

    private FastId(long msb, long lsb) {
        this.msb = msb;
        this.lsb = lsb;
    }

    public static FastId randomFastId() {
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        long msb = rnd.nextLong();
        long lsb = rnd.nextLong();
        msb = msb & 0xFFFFFFFFFFFF0FFFL | 0x4000L;
        lsb = lsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new FastId(msb, lsb);
    }

    public String toString() {
        char[] out = new char[36];
        FastId.writeHex(out, 0, this.msb >>> 32 & 0xFFFFFFFFL, 8);
        out[8] = 45;
        FastId.writeHex(out, 9, this.msb >>> 16 & 0xFFFFL, 4);
        out[13] = 45;
        FastId.writeHex(out, 14, this.msb & 0xFFFFL, 4);
        out[18] = 45;
        FastId.writeHex(out, 19, this.lsb >>> 48 & 0xFFFFL, 4);
        out[23] = 45;
        FastId.writeHex(out, 24, this.lsb & 0xFFFFFFFFFFFFL, 12);
        return new String(out);
    }

    private static void writeHex(char[] dest, int offset, long value, int digits) {
        for (int i = digits - 1; i >= 0; --i) {
            dest[offset + i] = HEX[(int)(value & 0xFL)];
            value >>>= 4;
        }
    }

    @Override
    public int compareTo(FastId other) {
        int cmp = Long.compare(this.msb, other.msb);
        return cmp != 0 ? cmp : Long.compare(this.lsb, other.lsb);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FastId)) {
            return false;
        }
        FastId other = (FastId)obj;
        return this.msb == other.msb && this.lsb == other.lsb;
    }

    public int hashCode() {
        return (int)(this.msb ^ this.msb >>> 32 ^ this.lsb ^ this.lsb >>> 32);
    }
}

