/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.util.concurrent.Semaphore;
import org.verifyica.engine.common.Precondition;

public class SemaphoreRunnable
implements Runnable {
    private final Semaphore semaphore;
    private final Runnable runnable;

    public SemaphoreRunnable(Semaphore semaphore, Runnable runnable) {
        Precondition.notNull(semaphore, "semaphore is null");
        Precondition.notNull(runnable, "runnable is null");
        this.semaphore = semaphore;
        this.runnable = runnable;
    }

    @Override
    public void run() {
        try {
            this.semaphore.acquire();
            try {
                this.runnable.run();
            }
            finally {
                this.semaphore.release();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }
}

