/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.verifyica.engine.common.FastId;

public final class Stopwatch {
    private final FastId fastId = FastId.randomFastId();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    private long accumulatedNanos;
    private long startNanoTime;
    private boolean running;

    public Stopwatch() {
        this.reset();
    }

    public Stopwatch reset() {
        this.readWriteLock.writeLock().lock();
        try {
            this.accumulatedNanos = 0L;
            this.startNanoTime = System.nanoTime();
            this.running = true;
            Stopwatch stopwatch = this;
            return stopwatch;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Stopwatch start() {
        this.readWriteLock.writeLock().lock();
        try {
            if (!this.running) {
                this.startNanoTime = System.nanoTime();
                this.running = true;
            }
            Stopwatch stopwatch = this;
            return stopwatch;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public Stopwatch stop() {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.running) {
                long now = System.nanoTime();
                this.accumulatedNanos += now - this.startNanoTime;
                this.running = false;
            }
            Stopwatch stopwatch = this;
            return stopwatch;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration elapsed() {
        this.readWriteLock.readLock().lock();
        try {
            long total = this.accumulatedNanos;
            if (this.running) {
                total += System.nanoTime() - this.startNanoTime;
            }
            Duration duration = Duration.ofNanos(total);
            return duration;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public Duration lap() {
        return this.elapsed();
    }

    public boolean isRunning() {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.running;
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public String toString() {
        return String.valueOf(this.elapsed().toNanos());
    }

    public boolean equals(Object o) {
        if (!(o instanceof Stopwatch)) {
            return false;
        }
        Stopwatch stopwatch = (Stopwatch)o;
        return Objects.equals(this.fastId, stopwatch.fastId);
    }

    public int hashCode() {
        return Objects.hashCode(this.fastId);
    }
}

