/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common.throttle;

import java.util.Random;
import org.verifyica.engine.common.throttle.Throttle;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;

public class RandomSleepThrottle
implements Throttle {
    private static final Logger LOGGER = LoggerFactory.getLogger(Throttle.class);
    private static final Random RANDOM = new Random();
    private final String name;
    private final long minimum;
    private final long maximum;

    public RandomSleepThrottle(String name, long minimum, long maximum) {
        this.name = name;
        this.minimum = minimum >= 0L ? Math.min(minimum, maximum) : 0L;
        this.maximum = maximum >= 0L ? Math.max(minimum, maximum) : 0L;
    }

    @Override
    public void throttle() throws InterruptedException {
        if (this.minimum == this.maximum && this.minimum == 0L) {
            return;
        }
        long throttle = this.minimum == this.maximum ? this.minimum : RandomSleepThrottle.randomLong(this.minimum, this.maximum);
        LOGGER.trace("name [%s] throttle [%d] ms", this.name, throttle);
        Thread.sleep(throttle);
    }

    private static long randomLong(long minimum, long maximum) {
        if (minimum == maximum) {
            return minimum;
        }
        return (long)(RANDOM.nextDouble() * (double)(maximum - minimum + 1L)) + minimum;
    }
}

