/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.common.throttle;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.concurrent.TimeUnit;
import org.verifyica.engine.common.throttle.Throttle;

public class SystemLoadAverageThrottle
implements Throttle {
    private static final double TARGET_MAXIMUM_LOAD_PERCENTAGE = 0.8;
    private static final long BASE_SLEEP_TIME_MS = 100L;
    private static final long MAXIMUM_SLEEP_TIME_MS = 5000L;
    private final double maximumLoad;
    private final OperatingSystemMXBean operatingSystemMXBean;

    private SystemLoadAverageThrottle(double targetMaximumLoad) {
        if (targetMaximumLoad <= 0.0 || targetMaximumLoad > 1.0) {
            throw new IllegalArgumentException("Max load percentage must be between 0 and 1");
        }
        this.operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.maximumLoad = (double)this.operatingSystemMXBean.getAvailableProcessors() * targetMaximumLoad;
    }

    @Override
    public void throttle() throws InterruptedException {
        this.throttleWithMaxSleep(5000L);
    }

    private void throttleWithMaxSleep(long maxSleepTime) throws InterruptedException {
        double currentLoad = this.operatingSystemMXBean.getSystemLoadAverage();
        if (currentLoad > this.maximumLoad) {
            long sleepTime = this.calculateExponentialSleepTime(currentLoad, this.maximumLoad);
            sleepTime = Math.min(sleepTime, maxSleepTime);
            TimeUnit.MILLISECONDS.sleep(sleepTime);
            this.throttleWithMaxSleep(maxSleepTime);
        }
    }

    private long calculateExponentialSleepTime(double currentLoad, double maxLoad) {
        double excessLoad = currentLoad - maxLoad;
        long sleepTime = 100L;
        if (excessLoad > 0.0) {
            sleepTime = (long)(100.0 * Math.pow(2.0, excessLoad));
            sleepTime = Math.min(sleepTime, 5000L);
        }
        return sleepTime;
    }

    public static SystemLoadAverageThrottle getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final SystemLoadAverageThrottle INSTANCE = new SystemLoadAverageThrottle(0.8);

        private Holder() {
        }
    }
}

