/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.configuration;

import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.junit.platform.engine.ConfigurationParameters;
import org.verifyica.api.Configuration;
import org.verifyica.engine.common.Precondition;

public class ConcreteConfigurationParameters
implements ConfigurationParameters {
    private final Configuration configuration;

    public ConcreteConfigurationParameters(Configuration configuration) {
        Precondition.notNull(configuration, "configuration is null");
        this.configuration = configuration;
    }

    public Optional<String> get(String key) {
        Precondition.notNullOrBlank(key, "key is null", "key is blank");
        return Optional.ofNullable(this.configuration.getProperties().getProperty(key.trim()));
    }

    public Optional<Boolean> getBoolean(String key) {
        Precondition.notNullOrBlank(key, "key is null", "key is blank");
        String value = this.configuration.getProperties().getProperty(key.trim());
        if ("true".equals(value)) {
            return Optional.of(Boolean.TRUE);
        }
        return Optional.of(Boolean.FALSE);
    }

    public <T> Optional<T> get(String key, Function<String, T> transformer) {
        Precondition.notNullOrBlank(key, "key is null", "key is blank");
        Precondition.notNull(transformer, "transformer is null");
        String value = this.configuration.getProperties().getProperty(key.trim());
        return value != null ? Optional.ofNullable(transformer.apply(value)) : Optional.empty();
    }

    public int size() {
        return this.configuration.getProperties().size();
    }

    public Set<String> keySet() {
        return this.configuration.getProperties().stringPropertyNames();
    }
}

