/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.configuration;

import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import org.verifyica.api.Configuration;
import org.verifyica.engine.common.ImmutableProperties;

public class ImmutableConfiguration
implements Configuration {
    private final Path propertiesFilenamePath;
    private final Properties properties;

    public ImmutableConfiguration(Configuration configuration) {
        this.propertiesFilenamePath = configuration.getPropertiesPath().orElse(null);
        this.properties = new ImmutableProperties(configuration.getProperties());
    }

    public Optional<Path> propertiesPath() {
        return Optional.ofNullable(this.propertiesFilenamePath);
    }

    public Optional<Path> getPropertiesPath() {
        return this.propertiesPath();
    }

    public Properties properties() {
        return this.properties;
    }

    public Properties getProperties() {
        return this.properties();
    }
}

