/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.context;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.verifyica.api.ClassContext;
import org.verifyica.api.Configuration;
import org.verifyica.api.EngineContext;
import org.verifyica.engine.context.AbstractContext;

public class ConcreteClassContext
extends AbstractContext
implements ClassContext {
    private final EngineContext engineContext;
    private final Class<?> testClass;
    private final String testClassDisplayName;
    private final Set<String> testClassTags;
    private final int testArgumentParallelism;
    private final AtomicReference<Object> testClassInstanceReference;

    public ConcreteClassContext(EngineContext engineContext, Class<?> testClass, String testClassDisplayName, Set<String> testClassTags, int testArgumentParallelism, AtomicReference<Object> testClassInstanceReference) {
        this.engineContext = engineContext;
        this.testClass = testClass;
        this.testClassDisplayName = testClassDisplayName;
        this.testClassTags = testClassTags;
        this.testArgumentParallelism = testArgumentParallelism;
        this.testClassInstanceReference = testClassInstanceReference;
    }

    @Override
    public Configuration getConfiguration() {
        return this.engineContext.getConfiguration();
    }

    public EngineContext getEngineContext() {
        return this.engineContext;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public String getTestClassDisplayName() {
        return this.testClassDisplayName;
    }

    public Set<String> getTestClassTags() {
        return this.testClassTags;
    }

    public int getTestArgumentParallelism() {
        return this.testArgumentParallelism;
    }

    public Object getTestInstance() {
        Object testInstance = this.testClassInstanceReference.get();
        if (testInstance == null) {
            throw new IllegalStateException("The class instance has not yet been instantiated");
        }
        return testInstance;
    }

    public <V> V getTestInstance(Class<V> type) {
        Object testInstance = this.testClassInstanceReference.get();
        if (testInstance == null) {
            throw new IllegalStateException("The class instance has not yet been instantiated");
        }
        return type.cast(testInstance);
    }

    public String toString() {
        return "ConcreteClassContext{engineContext=" + this.engineContext + ", testClass=" + this.testClass + ", testClassDisplayName='" + this.testClassDisplayName + '\'' + ", testArgumentParallelism=" + this.testArgumentParallelism + ", testClassInstanceReference=" + this.testClassInstanceReference + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ConcreteClassContext that = (ConcreteClassContext)object;
        return this.testArgumentParallelism == that.testArgumentParallelism && Objects.equals(this.engineContext, that.engineContext) && Objects.equals(this.testClass, that.testClass) && Objects.equals(this.testClassDisplayName, that.testClassDisplayName) && Objects.equals(this.testClassInstanceReference.get(), that.testClassInstanceReference.get());
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.engineContext, this.testClass, this.testClassDisplayName, this.testArgumentParallelism, this.testClassInstanceReference);
    }
}

