/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.descriptor;

import 6bc6660d778dec84d62bc72b295ffd7b.io.github.thunkware.vt.bridge.ThreadNameRunnable;
import 6bc6660d778dec84d62bc72b295ffd7b.javax.inject.Inject;
import 6bc6660d778dec84d62bc72b295ffd7b.javax.inject.Named;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.verifyica.api.ClassContext;
import org.verifyica.api.ClassInterceptor;
import org.verifyica.api.EngineContext;
import org.verifyica.api.Execution;
import org.verifyica.api.ExtendedMap;
import org.verifyica.api.Verifyica;
import org.verifyica.engine.common.DirectExecutorService;
import org.verifyica.engine.common.SemaphoreRunnable;
import org.verifyica.engine.common.throttle.Throttle;
import org.verifyica.engine.context.ConcreteClassContext;
import org.verifyica.engine.descriptor.TestDescriptorStatus;
import org.verifyica.engine.descriptor.TestableTestDescriptor;
import org.verifyica.engine.inject.Injector;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.support.ExecutorServiceSupport;
import org.verifyica.engine.support.HashSupport;

public class ClassTestDescriptor
extends TestableTestDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassTestDescriptor.class);
    private static final ExecutorService DIRECT_EXECUTOR_SERVICE = new DirectExecutorService();
    private final Set<String> tags;
    private final int testArgumentParallelism;
    private final Class<?> testClass;
    private final List<Method> prepareMethods;
    private final List<Method> concludeMethods;
    private final List<Object> invocationArguments;
    private final List<Throwable> throwables;
    @Inject
    @Named(value="engineExecutionListener")
    private EngineExecutionListener engineExecutionListener;
    @Inject
    @Named(value="classInterceptors")
    private List<ClassInterceptor> classInterceptors;
    @Inject
    @Named(value="classInterceptorsReversed")
    private List<ClassInterceptor> classInterceptorsReversed;
    @Inject
    @Named(value="argumentExecutorService")
    private ExecutorService argumentExecutorService;
    @Inject
    @Named(value="engineContext")
    private EngineContext engineContext;
    private ClassContext classContext;
    private final AtomicReference<Object> testInstanceAtomicReference;
    private boolean markedSkipped;

    public ClassTestDescriptor(UniqueId uniqueId, String displayName, Set<String> tags, Class<?> testClass, int testArgumentParallelism, List<Method> prepareMethods, List<Method> concludeMethods) {
        super(uniqueId, displayName);
        this.tags = tags;
        this.testArgumentParallelism = testArgumentParallelism;
        this.testClass = testClass;
        this.prepareMethods = prepareMethods;
        this.concludeMethods = concludeMethods;
        this.testInstanceAtomicReference = new AtomicReference();
        this.throwables = new ArrayList<Throwable>();
        this.invocationArguments = new ArrayList<Object>();
    }

    public Optional<TestSource> getSource() {
        return Optional.of(ClassSource.from(this.testClass));
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    @Override
    public ClassTestDescriptor test() {
        try {
            this.classContext = new ConcreteClassContext(this.engineContext, this.testClass, this.getDisplayName(), this.tags, this.testArgumentParallelism, this.testInstanceAtomicReference);
            this.classInterceptors = this.classInterceptors.stream().filter(classInterceptor -> {
                Predicate predicate = classInterceptor.predicate();
                return predicate == null || predicate.test(this.classContext);
            }).collect(Collectors.toList());
            this.classInterceptorsReversed = this.classInterceptorsReversed.stream().filter(classInterceptor -> {
                Predicate predicate = classInterceptor.predicate();
                return predicate == null || predicate.test(this.classContext);
            }).collect(Collectors.toList());
            this.engineExecutionListener.executionStarted((TestDescriptor)this);
            for (TestDescriptor testDescriptor : this.getChildren()) {
                Injector.inject("engineExecutionListener", (Object)this.engineExecutionListener, (Object)testDescriptor);
                Injector.inject("classInterceptors", this.classInterceptors, (Object)testDescriptor);
                Injector.inject("classInterceptorsReversed", this.classInterceptorsReversed, (Object)testDescriptor);
                Injector.inject("classContext", (Object)this.classContext, (Object)testDescriptor);
            }
            Throttle throttle = this.createThrottle(this.classContext.getConfiguration(), "verifyica.engine.class.state.machine.throttle");
            State state = State.START;
            block14: while (state != State.END) {
                LOGGER.trace("testDescriptor [%s] state [%s]", new Object[]{this, state});
                throttle.throttle();
                switch (state.ordinal()) {
                    case 0: {
                        state = State.INSTANTIATE;
                        continue block14;
                    }
                    case 1: {
                        state = this.doInstantiate();
                        continue block14;
                    }
                    case 2: {
                        state = this.doPrepare();
                        continue block14;
                    }
                    case 3: {
                        state = this.doTest();
                        continue block14;
                    }
                    case 4: {
                        state = this.doSkipChildren();
                        continue block14;
                    }
                    case 5: {
                        state = this.doConclude();
                        continue block14;
                    }
                    case 8: {
                        state = this.doDestroy();
                        continue block14;
                    }
                    case 6: {
                        state = this.doCloseInstance();
                        continue block14;
                    }
                    case 7: {
                        state = this.doCleanupClassContext();
                        continue block14;
                    }
                }
                throw new IllegalStateException(String.format("Invalid State [%s]", new Object[]{state}));
            }
            if (this.markedSkipped) {
                this.setTestDescriptorStatus(TestDescriptorStatus.skipped());
                this.engineExecutionListener.executionSkipped((TestDescriptor)this, "Skipped");
            } else {
                TestDescriptorStatus testDescriptorStatus;
                TestExecutionResult testExecutionResult;
                if (this.throwables.isEmpty()) {
                    testExecutionResult = TestExecutionResult.successful();
                    testDescriptorStatus = TestDescriptorStatus.passed();
                } else {
                    testExecutionResult = TestExecutionResult.failed((Throwable)this.throwables.get(0));
                    testDescriptorStatus = TestDescriptorStatus.failed(this.throwables.get(0));
                }
                this.setTestDescriptorStatus(testDescriptorStatus);
                this.engineExecutionListener.executionFinished((TestDescriptor)this, testExecutionResult);
            }
        }
        catch (Throwable t) {
            ClassTestDescriptor.printStackTrace(t);
            this.setTestDescriptorStatus(TestDescriptorStatus.failed(t));
            this.engineExecutionListener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)t));
        }
        return this;
    }

    @Override
    public void skip() {
        this.engineExecutionListener.executionStarted((TestDescriptor)this);
        this.getChildren().stream().map(TESTABLE_TEST_DESCRIPTOR_MAPPER).forEach(TestableTestDescriptor::skip);
        this.engineExecutionListener.executionSkipped((TestDescriptor)this, "Skipped");
        this.setTestDescriptorStatus(TestDescriptorStatus.skipped());
    }

    private State doInstantiate() {
        Throwable throwable = null;
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptors) {
                classInterceptor.preInstantiate(this.engineContext, this.testClass);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable == null) {
            try {
                Injector.inject(Verifyica.Autowired.class, (Object)this.classContext.getConfiguration(), this.getTestClass());
                Injector.inject(Verifyica.Autowired.class, (Object)this.engineContext, this.getTestClass());
                Object object = this.getTestClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                Injector.inject(Verifyica.Autowired.class, (Object)this.classContext.getConfiguration(), object);
                Injector.inject(Verifyica.Autowired.class, (Object)this.engineContext, object);
                this.testInstanceAtomicReference.set(object);
                this.invocationArguments.add(object);
                this.invocationArguments.add(this.classContext);
            }
            catch (Throwable t) {
                throwable = t.getCause();
            }
        }
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptorsReversed) {
                classInterceptor.postInstantiate(this.engineContext, this.testClass, this.testInstanceAtomicReference.get(), throwable);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        return throwable == null ? State.PREPARE : State.CLEAN_UP;
    }

    private State doPrepare() {
        Throwable throwable = null;
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptors) {
                classInterceptor.prePrepare(this.classContext);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable == null) {
            try {
                for (Method method : this.prepareMethods) {
                    ClassTestDescriptor.invoke(method, this.testInstanceAtomicReference.get(), this.invocationArguments, true);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Execution.ExecutionSkippedException) {
                    this.markedSkipped = true;
                } else {
                    throwable = cause;
                }
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptorsReversed) {
                classInterceptor.postPrepare(this.classContext, throwable);
            }
        }
        catch (Throwable t) {
            throwable = t;
            ClassTestDescriptor.printStackTrace(t);
            this.throwables.add(t);
        }
        if (this.markedSkipped) {
            return State.SKIP;
        }
        if (throwable == null) {
            return State.TEST;
        }
        return State.SKIP;
    }

    private State doTest() {
        ExecutorService executorService = this.testArgumentParallelism > 1 ? this.argumentExecutorService : DIRECT_EXECUTOR_SERVICE;
        List testableTestDescriptors = this.getChildren().stream().filter(TESTABLE_TEST_DESCRIPTOR_FILTER).map(TESTABLE_TEST_DESCRIPTOR_MAPPER).collect(Collectors.toList());
        ArrayList futures = new ArrayList();
        Semaphore semaphore = new Semaphore(this.testArgumentParallelism, true);
        for (TestableTestDescriptor testableTestDescriptor : testableTestDescriptors) {
            String threadName = Thread.currentThread().getName();
            threadName = threadName.substring(0, threadName.indexOf("/") + 1) + HashSupport.alphanumeric(6);
            ThreadNameRunnable threadNameRunnable = new ThreadNameRunnable(threadName, testableTestDescriptor::test);
            SemaphoreRunnable semaphoreRunnable = new SemaphoreRunnable(semaphore, threadNameRunnable);
            Future<?> future = executorService.submit(semaphoreRunnable);
            futures.add(future);
        }
        ExecutorServiceSupport.waitForAllFutures(futures, this.argumentExecutorService);
        return State.CONCLUDE;
    }

    private State doSkipChildren() {
        this.getChildren().stream().map(TESTABLE_TEST_DESCRIPTOR_MAPPER).forEach(testableTestDescriptor -> {
            Injector.inject("engineExecutionListener", (Object)this.engineExecutionListener, testableTestDescriptor);
            Injector.inject("classInterceptors", this.classInterceptors, testableTestDescriptor);
            Injector.inject("classInterceptorsReversed", this.classInterceptorsReversed, testableTestDescriptor);
            Injector.inject("classContext", (Object)this.classContext, testableTestDescriptor);
            testableTestDescriptor.skip();
        });
        return State.CONCLUDE;
    }

    private State doConclude() {
        Throwable throwable = null;
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptors) {
                classInterceptor.preConclude(this.classContext);
            }
        }
        catch (Throwable t) {
            throwable = t;
        }
        if (throwable == null) {
            try {
                for (Method method : this.concludeMethods) {
                    ClassTestDescriptor.invoke(method, this.testInstanceAtomicReference.get(), this.invocationArguments, true);
                }
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof Execution.ExecutionSkippedException)) {
                    throwable = cause;
                }
            }
            catch (Throwable t) {
                throwable = t;
            }
        }
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptorsReversed) {
                classInterceptor.postConclude(this.classContext, throwable);
            }
        }
        catch (Throwable t) {
            ClassTestDescriptor.printStackTrace(t);
            this.throwables.add(t);
        }
        return State.DESTROY;
    }

    private State doDestroy() {
        try {
            for (ClassInterceptor classInterceptor : this.classInterceptorsReversed) {
                classInterceptor.onDestroy(this.classContext);
            }
        }
        catch (Throwable t) {
            ClassTestDescriptor.printStackTrace(t);
            this.throwables.add(t);
        }
        return State.CLOSE;
    }

    private State doCloseInstance() {
        if (this.testInstanceAtomicReference.get() instanceof AutoCloseable) {
            try {
                ((AutoCloseable)this.testInstanceAtomicReference.get()).close();
            }
            catch (Throwable t) {
                ClassTestDescriptor.printStackTrace(t);
                this.throwables.add(t);
            }
        }
        this.testInstanceAtomicReference.set(null);
        return State.CLEAN_UP;
    }

    private State doCleanupClassContext() {
        ExtendedMap map = this.classContext.getMap();
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            if (!(entry.getValue() instanceof AutoCloseable)) continue;
            try {
                ((AutoCloseable)entry.getValue()).close();
            }
            catch (Throwable t) {
                ClassTestDescriptor.printStackTrace(t);
                this.throwables.add(t);
            }
        }
        map.clear();
        return State.END;
    }

    private static enum State {
        START,
        INSTANTIATE,
        PREPARE,
        TEST,
        SKIP,
        CONCLUDE,
        CLOSE,
        CLEAN_UP,
        DESTROY,
        END;

    }
}

