/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.descriptor;

import java.util.Objects;

public class TestDescriptorStatus {
    private static final TestDescriptorStatus PASSED = new TestDescriptorStatus(Type.PASSED);
    private static final TestDescriptorStatus SKIPPED = new TestDescriptorStatus(Type.SKIPPED);
    private final Type type;
    private final Throwable throwable;

    private TestDescriptorStatus(Type type) {
        this(type, null);
    }

    private TestDescriptorStatus(Type type, Throwable throwable) {
        this.type = type;
        this.throwable = throwable;
    }

    public Type getType() {
        return this.type;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isSuccess() {
        return this.type == Type.PASSED;
    }

    public boolean isFailure() {
        return this.type == Type.FAILED;
    }

    public boolean isSkipped() {
        return this.type == Type.SKIPPED;
    }

    public boolean isSkippedWithThrowable() {
        return this.type == Type.SKIPPED && this.throwable != null;
    }

    public String toString() {
        return "InvocationResult{type=" + (Object)((Object)this.type) + ", throwable=" + this.throwable + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestDescriptorStatus that = (TestDescriptorStatus)o;
        return this.type == that.type && Objects.equals(this.throwable, that.throwable);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.throwable});
    }

    public static TestDescriptorStatus passed() {
        return PASSED;
    }

    public static TestDescriptorStatus skipped() {
        return SKIPPED;
    }

    public static TestDescriptorStatus skipped(Throwable throwable) {
        return new TestDescriptorStatus(Type.SKIPPED, throwable);
    }

    public static TestDescriptorStatus failed(Throwable throwable) {
        return new TestDescriptorStatus(Type.FAILED, throwable);
    }

    public static enum Type {
        PASSED,
        FAILED,
        SKIPPED;

    }
}

