/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.filter;

import java.util.LinkedHashSet;
import java.util.List;
import org.verifyica.engine.api.ClassDefinition;
import org.verifyica.engine.filter.Filter;
import org.verifyica.engine.filter.FilterFactory;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;

public class ClassDefinitionFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassDefinitionFilter.class);

    private ClassDefinitionFilter() {
    }

    public static void filter(List<ClassDefinition> classDefinitions) {
        LOGGER.trace("filter()");
        List<Filter> filters = FilterFactory.loadFilters();
        LinkedHashSet<ClassDefinition> workingClassDefinitionSet = new LinkedHashSet<ClassDefinition>(classDefinitions);
        classDefinitions.forEach(classDefinition -> {
            for (Filter filter : filters) {
                Class<?> testClass = classDefinition.getTestClass();
                switch (filter.getType()) {
                    case EXCLUDE_CLASS: 
                    case EXCLUDE_TAGGED_CLASS: {
                        if (!filter.matches(testClass)) break;
                        workingClassDefinitionSet.remove(classDefinition);
                        break;
                    }
                    case INCLUDE_CLASS: 
                    case INCLUDE_TAGGED_CLASS: {
                        if (!filter.matches(testClass)) break;
                        workingClassDefinitionSet.add((ClassDefinition)classDefinition);
                        break;
                    }
                }
            }
        });
        classDefinitions.clear();
        classDefinitions.addAll(workingClassDefinitionSet);
    }
}

