/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.filter;

import org.verifyica.engine.filter.AbstractFilter;
import org.verifyica.engine.filter.Filter;
import org.verifyica.engine.support.TagSupport;

public class ExcludeTaggedClassFilter
extends AbstractFilter {
    private ExcludeTaggedClassFilter(String classNameRegex) {
        super(classNameRegex);
    }

    @Override
    public Filter.Type getType() {
        return Filter.Type.EXCLUDE_TAGGED_CLASS;
    }

    @Override
    public boolean matches(Class<?> testClass) {
        for (String tag : TagSupport.getTags(testClass)) {
            if (!this.getClassNamePattern().matcher(tag).find()) continue;
            return true;
        }
        return false;
    }

    public static ExcludeTaggedClassFilter create(String classRegex) {
        return new ExcludeTaggedClassFilter(classRegex);
    }
}

