/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.inject;

import 6bc6660d778dec84d62bc72b295ffd7b.javax.inject.Inject;
import 6bc6660d778dec84d62bc72b295ffd7b.javax.inject.Named;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.verifyica.engine.exception.EngineException;

public class Injector {
    private static final String JAVA_PACKAGE = "java.";
    private static final String SUN_PACKAGE = "sun.";
    private static final Map<Class<?>, List<Field>> FIELD_CACHE = new ConcurrentHashMap();
    private static final ReentrantLock FIELD_LOCK = new ReentrantLock(true);

    private Injector() {
    }

    public static void inject(String name, Object value, Object target) {
        Class<?> clazz = target.getClass();
        String className = clazz.getName();
        while (!className.startsWith(JAVA_PACKAGE) && !className.startsWith(SUN_PACKAGE)) {
            for (Field field : Injector.getFields(clazz)) {
                Inject inject = field.getAnnotation(Inject.class);
                Named named = field.getAnnotation(Named.class);
                if (inject == null || named == null || !named.value().equals(name) || Modifier.isStatic(field.getModifiers()) || !field.getType().isAssignableFrom(value.getClass())) continue;
                Injector.setField(field, target, value);
            }
            clazz = clazz.getSuperclass();
            className = clazz.getName();
        }
    }

    public static void inject(Class<? extends Annotation> annotation, Object value, Object target) {
        Class<?> clazz = target.getClass();
        String className = clazz.getName();
        while (!className.startsWith(JAVA_PACKAGE) && !className.startsWith(SUN_PACKAGE)) {
            for (Field field : Injector.getFields(clazz)) {
                if (Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(annotation) || !field.getType().isAssignableFrom(value.getClass())) continue;
                Injector.setField(field, target, value);
            }
            clazz = clazz.getSuperclass();
            className = clazz.getName();
        }
    }

    public static void inject(Class<? extends Annotation> annotation, Object value, Class<?> target) {
        Class<?> clazz = target;
        String className = clazz.getName();
        while (!className.startsWith(JAVA_PACKAGE) && !className.startsWith(SUN_PACKAGE)) {
            for (Field field : Injector.getFields(clazz)) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.isAnnotationPresent(annotation) || !field.getType().isAssignableFrom(value.getClass())) continue;
                Injector.setField(field, null, value);
            }
            clazz = clazz.getSuperclass();
            className = clazz.getName();
        }
    }

    private static List<Field> getFields(Class<?> clazz) {
        return FIELD_CACHE.computeIfAbsent(clazz, c -> Arrays.asList(c.getDeclaredFields()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setField(Field field, Object target, Object value) {
        FIELD_LOCK.lock();
        try {
            boolean originalAccessibility = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(target, value);
            }
            catch (IllegalAccessException e) {
                throw new EngineException(String.format("Exception injecting object into field [%s]", field.getName()), e);
            }
            finally {
                field.setAccessible(originalAccessibility);
            }
        }
        finally {
            FIELD_LOCK.unlock();
        }
    }
}

