/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.interceptor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.verifyica.api.Configuration;
import org.verifyica.api.EngineContext;
import org.verifyica.api.EngineInterceptor;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.common.StackTracePrinter;
import org.verifyica.engine.exception.EngineException;
import org.verifyica.engine.interceptor.ClassInterceptorRegistry;
import org.verifyica.engine.interceptor.InterceptorPredicates;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.support.ClassSupport;
import org.verifyica.engine.support.ObjectSupport;
import org.verifyica.engine.support.OrderSupport;

public class EngineInterceptorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInterceptorRegistry.class);
    private final Configuration configuration;
    private final ReadWriteLock readWriteLock;
    private final List<EngineInterceptor> engineInterceptors;

    public EngineInterceptorRegistry(Configuration configuration) {
        this.configuration = configuration;
        this.readWriteLock = new ReentrantReadWriteLock(true);
        this.engineInterceptors = new ArrayList<EngineInterceptor>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(EngineContext engineContext) {
        this.readWriteLock.writeLock().lock();
        try {
            ArrayList autowiredEngineInterceptors = new ArrayList(ClassSupport.findAllClasses(InterceptorPredicates.AUTOWIRED_ENGINE_INTERCEPTOR_CLASS));
            this.filter(autowiredEngineInterceptors);
            OrderSupport.orderClasses(autowiredEngineInterceptors);
            LOGGER.trace("autowired engine interceptor count [%d]", autowiredEngineInterceptors.size());
            for (Class clazz : autowiredEngineInterceptors) {
                try {
                    LOGGER.trace("loading autowired engine interceptor [%s]", clazz.getName());
                    Object object = ObjectSupport.createObject(clazz);
                    this.engineInterceptors.add((EngineInterceptor)object);
                    LOGGER.trace("autowired class interceptor [%s] loaded", clazz.getName());
                }
                catch (EngineException e) {
                    throw e;
                }
                catch (Throwable t) {
                    throw new EngineException(t);
                }
            }
            try {
                for (EngineInterceptor engineInterceptor : this.engineInterceptors) {
                    engineInterceptor.initialize(engineContext);
                }
            }
            catch (Throwable t) {
                throw new EngineException(t);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public List<EngineInterceptor> getEngineInterceptors() {
        this.readWriteLock.readLock().lock();
        try {
            ArrayList<EngineInterceptor> arrayList = new ArrayList<EngineInterceptor>(this.engineInterceptors);
            return arrayList;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    public void destroy(EngineContext engineContext) {
        for (EngineInterceptor engineInterceptor : this.engineInterceptors) {
            try {
                engineInterceptor.destroy(engineContext);
            }
            catch (Throwable t) {
                StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
            }
        }
    }

    private void filter(List<Class<?>> classes) {
        LinkedHashSet filteredClasses = new LinkedHashSet(classes);
        Optional.ofNullable(this.configuration.getProperties().getProperty("verifyica.engine.autowired.engine.interceptors.exclude.regex")).ifPresent(regex -> {
            LOGGER.trace("%s [%s]", "verifyica.engine.autowired.engine.interceptors.exclude.regex", regex);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher("");
            Iterator iterator = filteredClasses.iterator();
            while (iterator.hasNext()) {
                Class clazz = (Class)iterator.next();
                matcher.reset(clazz.getName());
                if (!matcher.find()) continue;
                LOGGER.trace("removing class interceptor [%s]", clazz.getName());
                iterator.remove();
            }
        });
        Optional.ofNullable(this.configuration.getProperties().getProperty("verifyica.engine.autowired.engine.interceptors.include.regex")).ifPresent(regex -> {
            LOGGER.trace("%s [%s]", "verifyica.engine.autowired.engine.interceptors.include.regex", regex);
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher("");
            for (Class clazz : classes) {
                matcher.reset(clazz.getName());
                if (!matcher.find()) continue;
                LOGGER.trace("adding class interceptor [%s]", clazz.getName());
                filteredClasses.add(clazz);
            }
        });
        classes.clear();
        classes.addAll(filteredClasses);
    }
}

