/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.listener;

import java.time.Duration;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.common.AnsiColoredString;
import org.verifyica.engine.common.StackTracePrinter;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.configuration.ConcreteConfiguration;
import org.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.verifyica.engine.descriptor.ClassTestDescriptor;
import org.verifyica.engine.descriptor.TestDescriptorStatus;
import org.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.verifyica.engine.descriptor.TestableTestDescriptor;
import org.verifyica.engine.logger.Logger;
import org.verifyica.engine.logger.LoggerFactory;
import org.verifyica.engine.support.TimestampSupport;

public class StatusEngineExecutionListener
implements EngineExecutionListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusEngineExecutionListener.class);
    private static final String INFO = new AnsiColoredString().append(AnsiColor.TEXT_WHITE).append("[").append(AnsiColor.TEXT_BLUE_BOLD).append("INFO").append(AnsiColor.TEXT_WHITE).append("]").append(AnsiColor.NONE).build();
    private static final String TEST = new AnsiColoredString().append(AnsiColor.TEXT_WHITE_BRIGHT).append("TEST").append(AnsiColor.NONE).build();
    private static final String PASS = new AnsiColoredString().append(AnsiColor.TEXT_GREEN_BOLD_BRIGHT).append("PASS").append(AnsiColor.NONE).build();
    private static final String FAIL = new AnsiColoredString().append(AnsiColor.TEXT_RED_BOLD_BRIGHT).append("FAIL").append(AnsiColor.NONE).build();
    private static final String SKIP = new AnsiColoredString().append(AnsiColor.TEXT_YELLOW_BOLD_BRIGHT).append("SKIP").append(AnsiColor.NONE).build();
    private final boolean consoleLogTests;
    private final String consoleLogTimingUnits;
    private final Map<TestDescriptor, Stopwatch> stopwatches;

    public StatusEngineExecutionListener() {
        ConcreteConfiguration configuration = ConcreteConfiguration.getInstance();
        this.consoleLogTests = !"false".equals(configuration.getProperties().getProperty("verifyica.maven.plugin.log.tests", "true"));
        this.consoleLogTimingUnits = configuration.getProperties().getProperty("verifyica.maven.plugin.log.units", "milliseconds");
        LOGGER.trace("configuration property [%s] = [%s]", "verifyica.maven.plugin.log.units", this.consoleLogTimingUnits);
        this.stopwatches = new ConcurrentHashMap<TestDescriptor, Stopwatch>();
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof TestableTestDescriptor) {
            this.stopwatches.put(testDescriptor, new Stopwatch());
            if (this.consoleLogTests) {
                try {
                    TestMethodTestDescriptor testMethodTestDescriptor;
                    String testArgumentDisplayName = null;
                    String testMethodDisplayName = null;
                    String testClassDisplayName = StatusEngineExecutionListener.findClassTestDescriptor(testDescriptor).getDisplayName();
                    ArgumentTestDescriptor argumentTestDescriptor = StatusEngineExecutionListener.findArgumentTestDescriptor(testDescriptor);
                    if (argumentTestDescriptor != null) {
                        testArgumentDisplayName = argumentTestDescriptor.getArgument().getName();
                    }
                    if ((testMethodTestDescriptor = StatusEngineExecutionListener.findTestMethodTestDescriptor(testDescriptor)) != null) {
                        testMethodDisplayName = testMethodTestDescriptor.getDisplayName() + "()";
                    }
                    AnsiColoredString ansiColorAnsiColoredString = new AnsiColoredString().append(INFO).append(" ").append(Thread.currentThread().getName()).append(" | ").append(TEST).append(AnsiColor.NONE);
                    if (testArgumentDisplayName != null) {
                        ansiColorAnsiColoredString.append(" | ").append(testArgumentDisplayName);
                    }
                    ansiColorAnsiColoredString.append(" | ").append(testClassDisplayName);
                    if (testMethodDisplayName != null) {
                        ansiColorAnsiColoredString.append(" | ").append(testMethodDisplayName);
                    }
                    ansiColorAnsiColoredString.append(AnsiColor.NONE);
                    System.out.println(ansiColorAnsiColoredString);
                }
                catch (Throwable t) {
                    StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
                }
            }
        }
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        if (testDescriptor instanceof TestableTestDescriptor) {
            Duration elapsedTime = this.stopwatches.remove(testDescriptor).stop().elapsed();
            try {
                TestMethodTestDescriptor testMethodTestDescriptor;
                String testArgumentDisplayName = null;
                String testMethodDisplayName = null;
                String testClassDisplayName = StatusEngineExecutionListener.findClassTestDescriptor(testDescriptor).getDisplayName();
                ArgumentTestDescriptor argumentTestDescriptor = StatusEngineExecutionListener.findArgumentTestDescriptor(testDescriptor);
                if (argumentTestDescriptor != null) {
                    testArgumentDisplayName = argumentTestDescriptor.getArgument().getName();
                }
                if ((testMethodTestDescriptor = StatusEngineExecutionListener.findTestMethodTestDescriptor(testDescriptor)) != null) {
                    testMethodDisplayName = testMethodTestDescriptor.getDisplayName() + "()";
                }
                AnsiColoredString ansiColoredString = new AnsiColoredString().append(INFO).append(" ").append(Thread.currentThread().getName()).append(" | ").append(AnsiColor.TEXT_WHITE_BRIGHT);
                ansiColoredString.append(SKIP).append(AnsiColor.NONE);
                if (testArgumentDisplayName != null) {
                    ansiColoredString.append(" | ").append(testArgumentDisplayName);
                }
                ansiColoredString.append(" | ").append(testClassDisplayName);
                if (testMethodDisplayName != null) {
                    ansiColoredString.append(" | ").append(testMethodDisplayName);
                }
                ansiColoredString.append(" ").append(TimestampSupport.toTimingUnit(elapsedTime.toNanos(), this.consoleLogTimingUnits));
                ansiColoredString.append(AnsiColor.NONE);
                System.out.println(ansiColoredString);
            }
            catch (Throwable t) {
                StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
            }
        }
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        if (testDescriptor instanceof TestableTestDescriptor) {
            Duration elapsedTime = this.stopwatches.remove(testDescriptor).stop().elapsed();
            try {
                TestMethodTestDescriptor testMethodTestDescriptor;
                String testArgumentDisplayName = null;
                String testMethodDisplayName = null;
                String testClassDisplayName = StatusEngineExecutionListener.findClassTestDescriptor(testDescriptor).getDisplayName();
                ArgumentTestDescriptor argumentTestDescriptor = StatusEngineExecutionListener.findArgumentTestDescriptor(testDescriptor);
                if (argumentTestDescriptor != null) {
                    testArgumentDisplayName = argumentTestDescriptor.getArgument().getName();
                }
                if ((testMethodTestDescriptor = StatusEngineExecutionListener.findTestMethodTestDescriptor(testDescriptor)) != null) {
                    testMethodDisplayName = testMethodTestDescriptor.getDisplayName() + "()";
                }
                AnsiColoredString ansiColoredString = new AnsiColoredString().append(INFO).append(" ").append(Thread.currentThread().getName()).append(" | ").append(AnsiColor.TEXT_WHITE_BRIGHT);
                TestExecutionResult.Status status = StatusEngineExecutionListener.getDescendantFailureCount(testDescriptor) > 0L ? TestExecutionResult.Status.FAILED : testExecutionResult.getStatus();
                switch (status) {
                    case SUCCESSFUL: {
                        ansiColoredString.append(PASS);
                        break;
                    }
                    case FAILED: {
                        ansiColoredString.append(FAIL);
                        break;
                    }
                    case ABORTED: {
                        ansiColoredString.append(SKIP);
                        break;
                    }
                    default: {
                        ansiColoredString.append(AnsiColor.TEXT_CYAN_BOLD.wrap("????"));
                    }
                }
                ansiColoredString.append(AnsiColor.NONE);
                if (testArgumentDisplayName != null) {
                    ansiColoredString.append(" | ").append(testArgumentDisplayName);
                }
                ansiColoredString.append(" | ").append(testClassDisplayName);
                if (testMethodDisplayName != null) {
                    ansiColoredString.append(" | ").append(testMethodDisplayName);
                }
                ansiColoredString.append(" ").append(TimestampSupport.toTimingUnit(elapsedTime.toNanos(), this.consoleLogTimingUnits)).append(AnsiColor.NONE);
                System.out.println(ansiColoredString);
            }
            catch (Throwable t) {
                StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
            }
        }
    }

    private static long getDescendantFailureCount(TestDescriptor testDescriptor) {
        Set descendants = testDescriptor.getDescendants();
        return descendants.stream().filter(descendant -> descendant instanceof TestableTestDescriptor).map(descendant -> (TestableTestDescriptor)((Object)descendant)).filter(testableTestDescriptor -> {
            TestDescriptorStatus testDescriptorStatus = testableTestDescriptor.getTestDescriptorStatus();
            return testDescriptorStatus != null && testDescriptorStatus.isFailure();
        }).count();
    }

    private static ClassTestDescriptor findClassTestDescriptor(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof ClassTestDescriptor) {
            return (ClassTestDescriptor)testDescriptor;
        }
        if (testDescriptor instanceof ArgumentTestDescriptor) {
            return testDescriptor.getParent().orElse(null);
        }
        if (testDescriptor instanceof TestMethodTestDescriptor) {
            return testDescriptor.getParent().flatMap(TestDescriptor::getParent).orElse(null);
        }
        return null;
    }

    private static ArgumentTestDescriptor findArgumentTestDescriptor(TestDescriptor testDescriptor) {
        if (testDescriptor instanceof ArgumentTestDescriptor) {
            return (ArgumentTestDescriptor)testDescriptor;
        }
        if (testDescriptor instanceof TestMethodTestDescriptor) {
            return testDescriptor.getParent().orElse(null);
        }
        return null;
    }

    private static TestMethodTestDescriptor findTestMethodTestDescriptor(TestDescriptor testDescriptor) {
        return testDescriptor instanceof TestMethodTestDescriptor ? (TestMethodTestDescriptor)testDescriptor : null;
    }
}

