/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.listener;

import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.verifyica.engine.VerifyicaTestEngine;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.common.AnsiColoredString;
import org.verifyica.engine.common.StackTracePrinter;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.verifyica.engine.descriptor.ClassTestDescriptor;
import org.verifyica.engine.descriptor.TestDescriptorStatus;
import org.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.verifyica.engine.descriptor.TestableTestDescriptor;
import org.verifyica.engine.support.TimestampSupport;

public class SummaryEngineExecutionListener
implements EngineExecutionListener {
    private static final String SUMMARY_BANNER = new AnsiColoredString().append(AnsiColor.TEXT_WHITE_BRIGHT).append("Verifyica ").append(VerifyicaTestEngine.staticGetVersion()).append(" Summary (").append(TimestampSupport.now()).append(")").append(AnsiColor.NONE).build();
    private static final String COMPACT_SUMMARY_BANNER = AnsiColor.TEXT_WHITE_BRIGHT.wrap("Compact Summary");
    private static final String SEPARATOR = AnsiColor.TEXT_WHITE_BRIGHT.wrap("------------------------------------------------------------------------");
    private static final String INFO = new AnsiColoredString().append(AnsiColor.TEXT_WHITE).append("[").append(AnsiColor.TEXT_BLUE_BOLD).append("INFO").append(AnsiColor.TEXT_WHITE).append("]").append(AnsiColor.NONE).append(" ").build();
    private static final Map<String, String> counterKeyToMessageDisplayStringMap = new HashMap<String, String>();
    private final Map<ClassTestDescriptor, TestExecutionResult.Status> classTestDescriptorTestExecutionResultStatusMap = new ConcurrentHashMap<ClassTestDescriptor, TestExecutionResult.Status>();
    private final Map<ClassTestDescriptor, String> classTestDescriptorSkippedMap = new ConcurrentHashMap<ClassTestDescriptor, String>();
    private final Map<ArgumentTestDescriptor, TestExecutionResult.Status> argumentTestDescriptorTestExecutionResultStatusMap = new ConcurrentHashMap<ArgumentTestDescriptor, TestExecutionResult.Status>();
    private final Map<ArgumentTestDescriptor, String> argumentTestDescriptorSkippedMap = new ConcurrentHashMap<ArgumentTestDescriptor, String>();
    private final Map<TestMethodTestDescriptor, TestExecutionResult.Status> testMethodTestDescriptorTestExecutionResultStatusMap = new ConcurrentHashMap<TestMethodTestDescriptor, TestExecutionResult.Status>();
    private final Map<TestMethodTestDescriptor, String> testMethodTestDescriptorSkippedMap = new ConcurrentHashMap<TestMethodTestDescriptor, String>();
    private final AtomicLong failureCount = new AtomicLong();
    private final Map<String, AtomicLong> counterMap = new ConcurrentHashMap<String, AtomicLong>();
    private final Stopwatch stopwatch = new Stopwatch();

    public void executionStarted(TestDescriptor testDescriptor) {
        if (testDescriptor.isRoot()) {
            this.stopwatch.reset();
        }
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        if (testDescriptor instanceof ClassTestDescriptor) {
            this.classTestDescriptorSkippedMap.put((ClassTestDescriptor)testDescriptor, reason);
        } else if (testDescriptor instanceof ArgumentTestDescriptor) {
            this.argumentTestDescriptorSkippedMap.put((ArgumentTestDescriptor)testDescriptor, reason);
        } else if (testDescriptor instanceof TestMethodTestDescriptor) {
            this.testMethodTestDescriptorSkippedMap.put((TestMethodTestDescriptor)testDescriptor, reason != null ? reason : "Skipped");
        }
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        TestExecutionResult.Status status;
        TestExecutionResult.Status status2 = status = SummaryEngineExecutionListener.getDescendantFailureCount(testDescriptor) > 0L ? TestExecutionResult.Status.FAILED : testExecutionResult.getStatus();
        if (testDescriptor instanceof ClassTestDescriptor) {
            this.classTestDescriptorTestExecutionResultStatusMap.put((ClassTestDescriptor)testDescriptor, status);
        } else if (testDescriptor instanceof ArgumentTestDescriptor) {
            this.argumentTestDescriptorTestExecutionResultStatusMap.put((ArgumentTestDescriptor)testDescriptor, status);
        } else if (testDescriptor instanceof TestMethodTestDescriptor) {
            this.testMethodTestDescriptorTestExecutionResultStatusMap.put((TestMethodTestDescriptor)testDescriptor, status);
        }
        if (testExecutionResult.getStatus() == TestExecutionResult.Status.FAILED) {
            this.failureCount.incrementAndGet();
        }
        if (testDescriptor.isRoot()) {
            this.summary();
        }
    }

    private void summary() {
        try {
            String[] keys;
            String key;
            TestExecutionResult.Status status;
            int i;
            this.stopwatch.stop();
            for (i = 0; i < this.classTestDescriptorSkippedMap.size(); ++i) {
                String string = "test.class.count";
                this.counterMap.computeIfAbsent(string, k -> new AtomicLong()).incrementAndGet();
                this.counterMap.computeIfAbsent(string + ".skipped", k -> new AtomicLong()).incrementAndGet();
            }
            for (i = 0; i < this.argumentTestDescriptorSkippedMap.size(); ++i) {
                String string = "test.argument.count";
                this.counterMap.computeIfAbsent(string, k -> new AtomicLong()).incrementAndGet();
                this.counterMap.computeIfAbsent(string + ".skipped", k -> new AtomicLong()).incrementAndGet();
            }
            for (i = 0; i < this.testMethodTestDescriptorSkippedMap.size(); ++i) {
                String string = "test.method.count";
                this.counterMap.computeIfAbsent(string, k -> new AtomicLong()).incrementAndGet();
                this.counterMap.computeIfAbsent(string + ".skipped", k -> new AtomicLong()).incrementAndGet();
            }
            for (Map.Entry<ClassTestDescriptor, TestExecutionResult.Status> entry : this.classTestDescriptorTestExecutionResultStatusMap.entrySet()) {
                status = entry.getValue();
                key = "test.class.count";
                this.counterMap.computeIfAbsent(key, k -> new AtomicLong()).incrementAndGet();
                switch (status) {
                    case SUCCESSFUL: {
                        this.counterMap.computeIfAbsent(key + ".successful", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.counterMap.computeIfAbsent(key + ".failed", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.counterMap.computeIfAbsent(key + ".skipped", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                }
            }
            for (Map.Entry<TestableTestDescriptor, TestExecutionResult.Status> entry : this.argumentTestDescriptorTestExecutionResultStatusMap.entrySet()) {
                status = entry.getValue();
                key = "test.argument.count";
                this.counterMap.computeIfAbsent(key, k -> new AtomicLong()).incrementAndGet();
                switch (status) {
                    case SUCCESSFUL: {
                        this.counterMap.computeIfAbsent(key + ".successful", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.counterMap.computeIfAbsent(key + ".failed", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.counterMap.computeIfAbsent(key + ".skipped", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                }
            }
            for (Map.Entry<TestableTestDescriptor, TestExecutionResult.Status> entry : this.testMethodTestDescriptorTestExecutionResultStatusMap.entrySet()) {
                status = entry.getValue();
                key = "test.method.count";
                this.counterMap.computeIfAbsent(key, k -> new AtomicLong()).incrementAndGet();
                switch (status) {
                    case SUCCESSFUL: {
                        this.counterMap.computeIfAbsent(key + ".successful", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case FAILED: {
                        this.counterMap.computeIfAbsent(key + ".failed", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                    case ABORTED: {
                        this.counterMap.computeIfAbsent(key + ".skipped", k -> new AtomicLong()).incrementAndGet();
                        break;
                    }
                }
            }
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            SummaryEngineExecutionListener.println(INFO + SUMMARY_BANNER);
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            int countPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".count")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int n = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".successful")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int failedPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".failed")).map(Map.Entry::getValue).collect(Collectors.toList()));
            int skipPad = SummaryEngineExecutionListener.getPad(this.counterMap.entrySet().stream().filter(mapEntry -> ((String)mapEntry.getKey()).endsWith(".skipped")).map(Map.Entry::getValue).collect(Collectors.toList()));
            StringBuilder compactSummary = new StringBuilder(COMPACT_SUMMARY_BANNER);
            compactSummary.append(AnsiColor.TEXT_WHITE_BRIGHT.wrap(" |"));
            for (String key3 : keys = new String[]{"test.class", "test.argument", "test.method"}) {
                String[] subKeys;
                key3 = key3 + ".count";
                long totalCount = this.counterMap.computeIfAbsent(key3, k -> new AtomicLong()).get();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(INFO).append(AnsiColor.TEXT_WHITE_BRIGHT.wrap(counterKeyToMessageDisplayStringMap.get(key3))).append(": ").append(AnsiColor.TEXT_WHITE_BRIGHT.wrap(SummaryEngineExecutionListener.pad(countPad, totalCount)));
                compactSummary.append(" ").append(AnsiColor.TEXT_WHITE_BRIGHT.wrap(totalCount));
                for (String subKey : subKeys = new String[]{key3 + ".successful", key3 + ".failed", key3 + ".skipped"}) {
                    String messageDisplayString = counterKeyToMessageDisplayStringMap.get(subKey);
                    long count = this.counterMap.computeIfAbsent(subKey, k -> new AtomicLong()).get();
                    String countDisplayString = "";
                    if (subKey.endsWith(".successful")) {
                        messageDisplayString = AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap(SummaryEngineExecutionListener.pad(n, count));
                        compactSummary.append(" ").append(AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap(count));
                    } else if (subKey.endsWith(".failed")) {
                        messageDisplayString = AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap(SummaryEngineExecutionListener.pad(failedPad, count));
                        compactSummary.append(" ").append(AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap(count));
                    } else if (subKey.endsWith(".skipped")) {
                        messageDisplayString = AnsiColor.TEXT_YELLOW_BOLD_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_YELLOW_BOLD_BRIGHT.wrap(SummaryEngineExecutionListener.pad(skipPad, count));
                        compactSummary.append(" ").append(AnsiColor.TEXT_YELLOW_BOLD_BRIGHT.wrap(count));
                    }
                    if (count == 0L) {
                        messageDisplayString = AnsiColor.stripAnsiEscapeSequences(messageDisplayString);
                        countDisplayString = AnsiColor.stripAnsiEscapeSequences(countDisplayString);
                        messageDisplayString = AnsiColor.TEXT_WHITE_BRIGHT.wrap(messageDisplayString);
                        countDisplayString = AnsiColor.TEXT_WHITE_BRIGHT.wrap(countDisplayString);
                    }
                    stringBuilder.append(" ").append(messageDisplayString).append(AnsiColor.TEXT_WHITE_BOLD).append(" : ").append(countDisplayString);
                }
                compactSummary.append(" ").append(AnsiColor.TEXT_WHITE_BRIGHT.wrap("|"));
                SummaryEngineExecutionListener.println(stringBuilder);
            }
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            String message = this.failureCount.get() > 0L ? AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap("TESTS FAILED") : AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap("TESTS PASSED");
            SummaryEngineExecutionListener.println(INFO + message);
            Duration elapsedTime = this.stopwatch.elapsed();
            if (this.failureCount.get() > 0L) {
                compactSummary.append(" ").append(AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap("TESTS FAILED"));
            } else {
                compactSummary.append(" ").append(AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap("TESTS PASSED"));
            }
            compactSummary.append(AnsiColor.TEXT_WHITE_BRIGHT.wrap(" | " + TimestampSupport.convertDurationToMillisAndNanoseconds(elapsedTime) + " ms"));
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            SummaryEngineExecutionListener.println(INFO + AnsiColor.TEXT_WHITE_BRIGHT.wrap(compactSummary));
            SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            SummaryEngineExecutionListener.println(new AnsiColoredString().append(INFO).append(AnsiColor.TEXT_WHITE_BRIGHT).append("Total time  : ").append(TimestampSupport.toHumanReadable(TimestampSupport.Format.SHORT, elapsedTime.toNanos())).append(" (").append((double)elapsedTime.toNanos() / 1000000.0).append(" ms)").append(AnsiColor.NONE));
            SummaryEngineExecutionListener.println(new AnsiColoredString().append(INFO).append(AnsiColor.TEXT_WHITE_BRIGHT).append("Finished at : ").append(TimestampSupport.now()).append(AnsiColor.NONE));
            if (this.failureCount.get() == 0L) {
                SummaryEngineExecutionListener.println(INFO + SEPARATOR);
            }
        }
        catch (Throwable t) {
            StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
        }
    }

    private static long getDescendantFailureCount(TestDescriptor testDescriptor) {
        Set descendants = testDescriptor.getDescendants();
        return descendants.stream().filter(descendant -> descendant instanceof TestableTestDescriptor).map(descendant -> (TestableTestDescriptor)((Object)descendant)).filter(testableTestDescriptor -> {
            TestDescriptorStatus testDescriptorStatus = testableTestDescriptor.getTestDescriptorStatus();
            return testDescriptorStatus != null && testDescriptorStatus.isFailure();
        }).count();
    }

    private static void println(Object object) {
        System.out.println(object);
    }

    private static int getPad(List<AtomicLong> atomicLongs) {
        return atomicLongs.stream().mapToInt(atomicLong -> String.valueOf(atomicLong.get()).length()).max().orElse(0);
    }

    private static String pad(long width, long value) {
        if (width > 0L) {
            return String.format("%" + width + "d", value);
        }
        return String.valueOf(value);
    }

    static {
        counterKeyToMessageDisplayStringMap.put("test.class.count", "Test classes   ");
        counterKeyToMessageDisplayStringMap.put("test.class.count.successful", "Passed");
        counterKeyToMessageDisplayStringMap.put("test.class.count.failed", "Failed");
        counterKeyToMessageDisplayStringMap.put("test.class.count.skipped", "Skipped");
        counterKeyToMessageDisplayStringMap.put("test.argument.count", "Test arguments ");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.successful", "Passed");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.failed", "Failed");
        counterKeyToMessageDisplayStringMap.put("test.argument.count.skipped", "Skipped");
        counterKeyToMessageDisplayStringMap.put("test.method.count", "Test methods   ");
        counterKeyToMessageDisplayStringMap.put("test.method.count.successful", "Passed");
        counterKeyToMessageDisplayStringMap.put("test.method.count.failed", "Failed");
        counterKeyToMessageDisplayStringMap.put("test.method.count.skipped", "Skipped");
    }
}

