/*
 * Decompiled with CFR 0.152.
 */
package org.verifyica.engine.listener;

import java.text.NumberFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.verifyica.engine.VerifyicaTestEngine;
import org.verifyica.engine.common.AnsiColor;
import org.verifyica.engine.common.AnsiColoredString;
import org.verifyica.engine.common.Counter;
import org.verifyica.engine.common.StackTracePrinter;
import org.verifyica.engine.common.Stopwatch;
import org.verifyica.engine.descriptor.ArgumentTestDescriptor;
import org.verifyica.engine.descriptor.ClassTestDescriptor;
import org.verifyica.engine.descriptor.TestDescriptorStatus;
import org.verifyica.engine.descriptor.TestMethodTestDescriptor;
import org.verifyica.engine.descriptor.TestableTestDescriptor;
import org.verifyica.engine.support.TimestampSupport;

public class SummaryEngineExecutionListener2
implements EngineExecutionListener {
    private static final String SUMMARY_BANNER = new AnsiColoredString().append(AnsiColor.TEXT_WHITE_BRIGHT).append("Verifyica ").append(VerifyicaTestEngine.staticGetVersion()).append(" Summary @ ").append(TimestampSupport.now()).append(AnsiColor.NONE).build();
    private static final String COMPACT_SUMMARY_BANNER = AnsiColor.TEXT_WHITE_BRIGHT.wrap("Compact Summary");
    private static final String SEPARATOR = AnsiColor.TEXT_WHITE_BRIGHT.wrap("------------------------------------------------------------------------");
    private static final String INFO = new AnsiColoredString().append(AnsiColor.TEXT_WHITE).append("[").append(AnsiColor.TEXT_BLUE_BOLD).append("INFO").append(AnsiColor.TEXT_WHITE).append("]").append(AnsiColor.NONE).append(" ").build();
    private final Map<String, Counter> counterMap = Collections.synchronizedMap(new LinkedHashMap());
    private final Stopwatch stopwatch;

    public SummaryEngineExecutionListener2() {
        new Counter("class.count", "Test Class Count").register(this.counterMap);
        new Counter("class.passed", "Test Class Passed Count").register(this.counterMap);
        new Counter("class.failed", "Test Class Failed Count").register(this.counterMap);
        new Counter("class.skipped", "Test Class Skipped Count").register(this.counterMap);
        new Counter("argument.count", "Test Argument Count").register(this.counterMap);
        new Counter("argument.passed", "Test Argument Passed Count").register(this.counterMap);
        new Counter("argument.failed", "Test Argument Failed Count").register(this.counterMap);
        new Counter("argument.skipped", "Test Argument Skipped Count").register(this.counterMap);
        new Counter("method.count", "Test Method Count").register(this.counterMap);
        new Counter("method.passed", "Test Method Passed Count").register(this.counterMap);
        new Counter("method.failed", "Test Method Failed Count").register(this.counterMap);
        new Counter("method.skipped", "Test Method Skipped Count").register(this.counterMap);
        this.stopwatch = new Stopwatch();
    }

    public void executionStarted(TestDescriptor testDescriptor) {
        if (testDescriptor.isRoot()) {
            this.stopwatch.reset();
        }
        String type = null;
        String suffix = ".count";
        if (testDescriptor instanceof ClassTestDescriptor) {
            type = "class";
        } else if (testDescriptor instanceof ArgumentTestDescriptor) {
            type = "argument";
        } else if (testDescriptor instanceof TestMethodTestDescriptor) {
            type = "method";
        }
        if (!testDescriptor.isRoot() && type != null) {
            this.counterMap.get(type + suffix).increment();
        }
    }

    public void executionSkipped(TestDescriptor testDescriptor, String reason) {
        String type = null;
        String suffix = ".skipped";
        if (testDescriptor instanceof ClassTestDescriptor) {
            type = "class";
        } else if (testDescriptor instanceof ArgumentTestDescriptor) {
            type = "argument";
        } else if (testDescriptor instanceof TestMethodTestDescriptor) {
            type = "method";
        }
        if (!testDescriptor.isRoot() && type != null) {
            this.counterMap.get(type + suffix).increment();
        }
    }

    public void executionFinished(TestDescriptor testDescriptor, TestExecutionResult testExecutionResult) {
        TestExecutionResult.Status status = SummaryEngineExecutionListener2.getDescendantFailureCount(testDescriptor) > 0L ? TestExecutionResult.Status.FAILED : testExecutionResult.getStatus();
        String type = null;
        String suffix = null;
        if (testDescriptor instanceof ClassTestDescriptor) {
            type = "class";
        } else if (testDescriptor instanceof ArgumentTestDescriptor) {
            type = "argument";
        } else if (testDescriptor instanceof TestMethodTestDescriptor) {
            type = "method";
        }
        if (status == TestExecutionResult.Status.ABORTED) {
            suffix = ".skipped";
        } else if (status == TestExecutionResult.Status.FAILED) {
            suffix = ".failed";
        } else if (status == TestExecutionResult.Status.SUCCESSFUL) {
            suffix = ".passed";
        }
        if (type != null && suffix != null) {
            this.counterMap.get(type + suffix).increment();
        }
        if (testDescriptor.isRoot()) {
            this.summary();
        }
    }

    private void summary() {
        try {
            this.stopwatch.stop();
            Duration elapsedTime = this.stopwatch.elapsed();
            long failureCount = 0L;
            SummaryEngineExecutionListener2.println(INFO + SEPARATOR);
            SummaryEngineExecutionListener2.println(INFO + SUMMARY_BANNER);
            SummaryEngineExecutionListener2.println(INFO + SEPARATOR);
            List<String> groups = Arrays.asList("class", "argument", "method");
            List<String> statuses = Arrays.asList("count", "passed", "skipped", "failed");
            SummaryEngineExecutionListener2.println(INFO + AnsiColor.TEXT_WHITE_BRIGHT.wrap(String.format("%-16s | %15s | %15s | %15s |", "Status", "Classes", "Arguments", "Methods")));
            SummaryEngineExecutionListener2.println(INFO + AnsiColor.TEXT_WHITE_BRIGHT.wrap("-----------------+-----------------+-----------------+-----------------+"));
            NumberFormat numberFormat = NumberFormat.getIntegerInstance();
            for (String status : statuses) {
                SummaryEngineExecutionListener2.print(INFO + AnsiColor.TEXT_WHITE_BRIGHT.wrap(String.format("%-16s |", SummaryEngineExecutionListener2.capitalize(status))));
                for (String group : groups) {
                    String key = String.format("%s.%s", group, status);
                    Counter counter = this.counterMap.get(key);
                    String count = counter != null ? numberFormat.format(counter.count()) : "-";
                    SummaryEngineExecutionListener2.print(AnsiColor.TEXT_WHITE_BRIGHT.wrap(String.format(" %15s |", count)));
                    if (!"failed".equals(status) || counter == null) continue;
                    failureCount += counter.count();
                }
                SummaryEngineExecutionListener2.println("");
            }
            SummaryEngineExecutionListener2.println(INFO + SEPARATOR);
            String message = failureCount > 0L ? AnsiColor.TEXT_RED_BOLD_BRIGHT.wrap("FAILED") : AnsiColor.TEXT_GREEN_BOLD_BRIGHT.wrap("PASSED");
            SummaryEngineExecutionListener2.println(INFO + message);
            SummaryEngineExecutionListener2.println(INFO + SEPARATOR);
            SummaryEngineExecutionListener2.println(new AnsiColoredString().append(INFO).append(AnsiColor.TEXT_WHITE_BRIGHT).append("Total time  : ").append(TimestampSupport.toHumanReadable(TimestampSupport.Format.SHORT, elapsedTime.toNanos())).append(" (").append((double)elapsedTime.toNanos() / 1000000.0).append(" ms)").append(AnsiColor.NONE));
            SummaryEngineExecutionListener2.println(new AnsiColoredString().append(INFO).append(AnsiColor.TEXT_WHITE_BRIGHT).append("Finished at : ").append(TimestampSupport.now()).append(AnsiColor.NONE));
        }
        catch (Throwable t) {
            StackTracePrinter.printStackTrace(t, AnsiColor.TEXT_RED_BOLD, System.err);
        }
    }

    private static long getDescendantFailureCount(TestDescriptor testDescriptor) {
        Set descendants = testDescriptor.getDescendants();
        return descendants.stream().filter(descendant -> descendant instanceof TestableTestDescriptor).map(descendant -> (TestableTestDescriptor)((Object)descendant)).filter(testableTestDescriptor -> {
            TestDescriptorStatus testDescriptorStatus = testableTestDescriptor.getTestDescriptorStatus();
            return testDescriptorStatus != null && testDescriptorStatus.isFailure();
        }).count();
    }

    private static void print(Object object) {
        System.out.print(object);
    }

    private static void println(Object object) {
        System.out.println(object);
    }

    private static int getPad(List<AtomicLong> atomicLongs) {
        return atomicLongs.stream().mapToInt(atomicLong -> String.valueOf(atomicLong.get()).length()).max().orElse(0);
    }

    private static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    private static String pad(long width, long value) {
        if (width > 0L) {
            return String.format("%" + width + "d", value);
        }
        return String.valueOf(value);
    }
}

